/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FeatureUsageDetailResponseData.Builder.class)
public final class FeatureUsageDetailResponseData {
    private final List<FeatureUsageResponseData> features;

    private final Map<String, Object> additionalProperties;

    private FeatureUsageDetailResponseData(
            List<FeatureUsageResponseData> features, Map<String, Object> additionalProperties) {
        this.features = features;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("features")
    public List<FeatureUsageResponseData> getFeatures() {
        return features;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FeatureUsageDetailResponseData && equalTo((FeatureUsageDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureUsageDetailResponseData other) {
        return features.equals(other.features);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.features);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<FeatureUsageResponseData> features = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(FeatureUsageDetailResponseData other) {
            features(other.getFeatures());
            return this;
        }

        @JsonSetter(value = "features", nulls = Nulls.SKIP)
        public Builder features(List<FeatureUsageResponseData> features) {
            this.features.clear();
            this.features.addAll(features);
            return this;
        }

        public Builder addFeatures(FeatureUsageResponseData features) {
            this.features.add(features);
            return this;
        }

        public Builder addAllFeatures(List<FeatureUsageResponseData> features) {
            this.features.addAll(features);
            return this;
        }

        public FeatureUsageDetailResponseData build() {
            return new FeatureUsageDetailResponseData(features, additionalProperties);
        }
    }
}
