/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FeatureUsageResponseData.Builder.class)
public final class FeatureUsageResponseData {
    private final boolean access;

    private final Optional<Integer> allocation;

    private final FeatureUsageResponseDataAllocationType allocationType;

    private final Optional<OffsetDateTime> entitlementExpirationDate;

    private final String entitlementId;

    private final String entitlementType;

    private final Optional<FeatureDetailResponseData> feature;

    private final Optional<OffsetDateTime> metricResetAt;

    private final Optional<String> monthReset;

    private final Optional<BillingPriceView> monthlyUsageBasedPrice;

    private final Optional<String> period;

    private final Optional<PlanResponseData> plan;

    private final Optional<String> priceBehavior;

    private final Optional<Integer> usage;

    private final Optional<BillingPriceView> yearlyUsageBasedPrice;

    private final Map<String, Object> additionalProperties;

    private FeatureUsageResponseData(
            boolean access,
            Optional<Integer> allocation,
            FeatureUsageResponseDataAllocationType allocationType,
            Optional<OffsetDateTime> entitlementExpirationDate,
            String entitlementId,
            String entitlementType,
            Optional<FeatureDetailResponseData> feature,
            Optional<OffsetDateTime> metricResetAt,
            Optional<String> monthReset,
            Optional<BillingPriceView> monthlyUsageBasedPrice,
            Optional<String> period,
            Optional<PlanResponseData> plan,
            Optional<String> priceBehavior,
            Optional<Integer> usage,
            Optional<BillingPriceView> yearlyUsageBasedPrice,
            Map<String, Object> additionalProperties) {
        this.access = access;
        this.allocation = allocation;
        this.allocationType = allocationType;
        this.entitlementExpirationDate = entitlementExpirationDate;
        this.entitlementId = entitlementId;
        this.entitlementType = entitlementType;
        this.feature = feature;
        this.metricResetAt = metricResetAt;
        this.monthReset = monthReset;
        this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
        this.period = period;
        this.plan = plan;
        this.priceBehavior = priceBehavior;
        this.usage = usage;
        this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Whether further usage is permitted.
     */
    @JsonProperty("access")
    public boolean getAccess() {
        return access;
    }

    /**
     * @return The maximum amount of usage that is permitted; a null value indicates that unlimited usage is permitted.
     */
    @JsonProperty("allocation")
    public Optional<Integer> getAllocation() {
        return allocation;
    }

    /**
     * @return The type of allocation that is being used.
     */
    @JsonProperty("allocation_type")
    public FeatureUsageResponseDataAllocationType getAllocationType() {
        return allocationType;
    }

    @JsonProperty("entitlement_expiration_date")
    public Optional<OffsetDateTime> getEntitlementExpirationDate() {
        return entitlementExpirationDate;
    }

    @JsonProperty("entitlement_id")
    public String getEntitlementId() {
        return entitlementId;
    }

    @JsonProperty("entitlement_type")
    public String getEntitlementType() {
        return entitlementType;
    }

    @JsonProperty("feature")
    public Optional<FeatureDetailResponseData> getFeature() {
        return feature;
    }

    /**
     * @return The time at which the metric will reset.
     */
    @JsonProperty("metric_reset_at")
    public Optional<OffsetDateTime> getMetricResetAt() {
        return metricResetAt;
    }

    /**
     * @return If the period is current_month, when the month resets.
     */
    @JsonProperty("month_reset")
    public Optional<String> getMonthReset() {
        return monthReset;
    }

    @JsonProperty("monthly_usage_based_price")
    public Optional<BillingPriceView> getMonthlyUsageBasedPrice() {
        return monthlyUsageBasedPrice;
    }

    /**
     * @return The period over which usage is measured.
     */
    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return period;
    }

    @JsonProperty("plan")
    public Optional<PlanResponseData> getPlan() {
        return plan;
    }

    @JsonProperty("price_behavior")
    public Optional<String> getPriceBehavior() {
        return priceBehavior;
    }

    /**
     * @return The amount of usage that has been consumed; a null value indicates that usage is not being measured.
     */
    @JsonProperty("usage")
    public Optional<Integer> getUsage() {
        return usage;
    }

    @JsonProperty("yearly_usage_based_price")
    public Optional<BillingPriceView> getYearlyUsageBasedPrice() {
        return yearlyUsageBasedPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FeatureUsageResponseData && equalTo((FeatureUsageResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureUsageResponseData other) {
        return access == other.access
                && allocation.equals(other.allocation)
                && allocationType.equals(other.allocationType)
                && entitlementExpirationDate.equals(other.entitlementExpirationDate)
                && entitlementId.equals(other.entitlementId)
                && entitlementType.equals(other.entitlementType)
                && feature.equals(other.feature)
                && metricResetAt.equals(other.metricResetAt)
                && monthReset.equals(other.monthReset)
                && monthlyUsageBasedPrice.equals(other.monthlyUsageBasedPrice)
                && period.equals(other.period)
                && plan.equals(other.plan)
                && priceBehavior.equals(other.priceBehavior)
                && usage.equals(other.usage)
                && yearlyUsageBasedPrice.equals(other.yearlyUsageBasedPrice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.access,
                this.allocation,
                this.allocationType,
                this.entitlementExpirationDate,
                this.entitlementId,
                this.entitlementType,
                this.feature,
                this.metricResetAt,
                this.monthReset,
                this.monthlyUsageBasedPrice,
                this.period,
                this.plan,
                this.priceBehavior,
                this.usage,
                this.yearlyUsageBasedPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccessStage builder() {
        return new Builder();
    }

    public interface AccessStage {
        AllocationTypeStage access(boolean access);

        Builder from(FeatureUsageResponseData other);
    }

    public interface AllocationTypeStage {
        EntitlementIdStage allocationType(@NotNull FeatureUsageResponseDataAllocationType allocationType);
    }

    public interface EntitlementIdStage {
        EntitlementTypeStage entitlementId(@NotNull String entitlementId);
    }

    public interface EntitlementTypeStage {
        _FinalStage entitlementType(@NotNull String entitlementType);
    }

    public interface _FinalStage {
        FeatureUsageResponseData build();

        _FinalStage allocation(Optional<Integer> allocation);

        _FinalStage allocation(Integer allocation);

        _FinalStage entitlementExpirationDate(Optional<OffsetDateTime> entitlementExpirationDate);

        _FinalStage entitlementExpirationDate(OffsetDateTime entitlementExpirationDate);

        _FinalStage feature(Optional<FeatureDetailResponseData> feature);

        _FinalStage feature(FeatureDetailResponseData feature);

        _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt);

        _FinalStage metricResetAt(OffsetDateTime metricResetAt);

        _FinalStage monthReset(Optional<String> monthReset);

        _FinalStage monthReset(String monthReset);

        _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice);

        _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice);

        _FinalStage period(Optional<String> period);

        _FinalStage period(String period);

        _FinalStage plan(Optional<PlanResponseData> plan);

        _FinalStage plan(PlanResponseData plan);

        _FinalStage priceBehavior(Optional<String> priceBehavior);

        _FinalStage priceBehavior(String priceBehavior);

        _FinalStage usage(Optional<Integer> usage);

        _FinalStage usage(Integer usage);

        _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice);

        _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccessStage, AllocationTypeStage, EntitlementIdStage, EntitlementTypeStage, _FinalStage {
        private boolean access;

        private FeatureUsageResponseDataAllocationType allocationType;

        private String entitlementId;

        private String entitlementType;

        private Optional<BillingPriceView> yearlyUsageBasedPrice = Optional.empty();

        private Optional<Integer> usage = Optional.empty();

        private Optional<String> priceBehavior = Optional.empty();

        private Optional<PlanResponseData> plan = Optional.empty();

        private Optional<String> period = Optional.empty();

        private Optional<BillingPriceView> monthlyUsageBasedPrice = Optional.empty();

        private Optional<String> monthReset = Optional.empty();

        private Optional<OffsetDateTime> metricResetAt = Optional.empty();

        private Optional<FeatureDetailResponseData> feature = Optional.empty();

        private Optional<OffsetDateTime> entitlementExpirationDate = Optional.empty();

        private Optional<Integer> allocation = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FeatureUsageResponseData other) {
            access(other.getAccess());
            allocation(other.getAllocation());
            allocationType(other.getAllocationType());
            entitlementExpirationDate(other.getEntitlementExpirationDate());
            entitlementId(other.getEntitlementId());
            entitlementType(other.getEntitlementType());
            feature(other.getFeature());
            metricResetAt(other.getMetricResetAt());
            monthReset(other.getMonthReset());
            monthlyUsageBasedPrice(other.getMonthlyUsageBasedPrice());
            period(other.getPeriod());
            plan(other.getPlan());
            priceBehavior(other.getPriceBehavior());
            usage(other.getUsage());
            yearlyUsageBasedPrice(other.getYearlyUsageBasedPrice());
            return this;
        }

        /**
         * <p>Whether further usage is permitted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("access")
        public AllocationTypeStage access(boolean access) {
            this.access = access;
            return this;
        }

        /**
         * <p>The type of allocation that is being used.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("allocation_type")
        public EntitlementIdStage allocationType(@NotNull FeatureUsageResponseDataAllocationType allocationType) {
            this.allocationType = Objects.requireNonNull(allocationType, "allocationType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_id")
        public EntitlementTypeStage entitlementId(@NotNull String entitlementId) {
            this.entitlementId = Objects.requireNonNull(entitlementId, "entitlementId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_type")
        public _FinalStage entitlementType(@NotNull String entitlementType) {
            this.entitlementType = Objects.requireNonNull(entitlementType, "entitlementType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = Optional.ofNullable(yearlyUsageBasedPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_usage_based_price", nulls = Nulls.SKIP)
        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
            return this;
        }

        /**
         * <p>The amount of usage that has been consumed; a null value indicates that usage is not being measured.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage usage(Integer usage) {
            this.usage = Optional.ofNullable(usage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "usage", nulls = Nulls.SKIP)
        public _FinalStage usage(Optional<Integer> usage) {
            this.usage = usage;
            return this;
        }

        @java.lang.Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_behavior", nulls = Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @java.lang.Override
        public _FinalStage plan(PlanResponseData plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan", nulls = Nulls.SKIP)
        public _FinalStage plan(Optional<PlanResponseData> plan) {
            this.plan = plan;
            return this;
        }

        /**
         * <p>The period over which usage is measured.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage period(String period) {
            this.period = Optional.ofNullable(period);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "period", nulls = Nulls.SKIP)
        public _FinalStage period(Optional<String> period) {
            this.period = period;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = Optional.ofNullable(monthlyUsageBasedPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_usage_based_price", nulls = Nulls.SKIP)
        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
            return this;
        }

        /**
         * <p>If the period is current_month, when the month resets.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage monthReset(String monthReset) {
            this.monthReset = Optional.ofNullable(monthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "month_reset", nulls = Nulls.SKIP)
        public _FinalStage monthReset(Optional<String> monthReset) {
            this.monthReset = monthReset;
            return this;
        }

        /**
         * <p>The time at which the metric will reset.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage metricResetAt(OffsetDateTime metricResetAt) {
            this.metricResetAt = Optional.ofNullable(metricResetAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_reset_at", nulls = Nulls.SKIP)
        public _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt) {
            this.metricResetAt = metricResetAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage feature(FeatureDetailResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature", nulls = Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureDetailResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @java.lang.Override
        public _FinalStage entitlementExpirationDate(OffsetDateTime entitlementExpirationDate) {
            this.entitlementExpirationDate = Optional.ofNullable(entitlementExpirationDate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entitlement_expiration_date", nulls = Nulls.SKIP)
        public _FinalStage entitlementExpirationDate(Optional<OffsetDateTime> entitlementExpirationDate) {
            this.entitlementExpirationDate = entitlementExpirationDate;
            return this;
        }

        /**
         * <p>The maximum amount of usage that is permitted; a null value indicates that unlimited usage is permitted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage allocation(Integer allocation) {
            this.allocation = Optional.ofNullable(allocation);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "allocation", nulls = Nulls.SKIP)
        public _FinalStage allocation(Optional<Integer> allocation) {
            this.allocation = allocation;
            return this;
        }

        @java.lang.Override
        public FeatureUsageResponseData build() {
            return new FeatureUsageResponseData(
                    access,
                    allocation,
                    allocationType,
                    entitlementExpirationDate,
                    entitlementId,
                    entitlementType,
                    feature,
                    metricResetAt,
                    monthReset,
                    monthlyUsageBasedPrice,
                    period,
                    plan,
                    priceBehavior,
                    usage,
                    yearlyUsageBasedPrice,
                    additionalProperties);
        }
    }
}
