/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanResponseData.Builder.class)
public final class PlanResponseData {
    private final Optional<String> audienceType;

    private final OffsetDateTime createdAt;

    private final String description;

    private final String icon;

    private final String id;

    private final String name;

    private final String planType;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private PlanResponseData(
            Optional<String> audienceType,
            OffsetDateTime createdAt,
            String description,
            String icon,
            String id,
            String name,
            String planType,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.createdAt = createdAt;
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.planType = planType;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("audience_type")
    public Optional<String> getAudienceType() {
        return audienceType;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("icon")
    public String getIcon() {
        return icon;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plan_type")
    public String getPlanType() {
        return planType;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanResponseData && equalTo((PlanResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanResponseData other) {
        return audienceType.equals(other.audienceType)
                && createdAt.equals(other.createdAt)
                && description.equals(other.description)
                && icon.equals(other.icon)
                && id.equals(other.id)
                && name.equals(other.name)
                && planType.equals(other.planType)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.audienceType,
                this.createdAt,
                this.description,
                this.icon,
                this.id,
                this.name,
                this.planType,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        DescriptionStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(PlanResponseData other);
    }

    public interface DescriptionStage {
        IconStage description(@NotNull String description);
    }

    public interface IconStage {
        IdStage icon(@NotNull String icon);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        PlanTypeStage name(@NotNull String name);
    }

    public interface PlanTypeStage {
        UpdatedAtStage planType(@NotNull String planType);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        PlanResponseData build();

        _FinalStage audienceType(Optional<String> audienceType);

        _FinalStage audienceType(String audienceType);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    DescriptionStage,
                    IconStage,
                    IdStage,
                    NameStage,
                    PlanTypeStage,
                    UpdatedAtStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String description;

        private String icon;

        private String id;

        private String name;

        private String planType;

        private OffsetDateTime updatedAt;

        private Optional<String> audienceType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanResponseData other) {
            audienceType(other.getAudienceType());
            createdAt(other.getCreatedAt());
            description(other.getDescription());
            icon(other.getIcon());
            id(other.getId());
            name(other.getName());
            planType(other.getPlanType());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DescriptionStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audience_type", nulls = Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @java.lang.Override
        public PlanResponseData build() {
            return new PlanResponseData(
                    audienceType, createdAt, description, icon, id, name, planType, updatedAt, additionalProperties);
        }
    }
}
