/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TemporaryAccessTokenResponseData.Builder.class)
public final class TemporaryAccessTokenResponseData {
    private final String apiKeyId;

    private final OffsetDateTime createdAt;

    private final String environmentId;

    private final OffsetDateTime expiredAt;

    private final String id;

    private final String resourceType;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private TemporaryAccessTokenResponseData(
            String apiKeyId,
            OffsetDateTime createdAt,
            String environmentId,
            OffsetDateTime expiredAt,
            String id,
            String resourceType,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.apiKeyId = apiKeyId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.expiredAt = expiredAt;
        this.id = id;
        this.resourceType = resourceType;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("api_key_id")
    public String getApiKeyId() {
        return apiKeyId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("expired_at")
    public OffsetDateTime getExpiredAt() {
        return expiredAt;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("resource_type")
    public String getResourceType() {
        return resourceType;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TemporaryAccessTokenResponseData && equalTo((TemporaryAccessTokenResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TemporaryAccessTokenResponseData other) {
        return apiKeyId.equals(other.apiKeyId)
                && createdAt.equals(other.createdAt)
                && environmentId.equals(other.environmentId)
                && expiredAt.equals(other.expiredAt)
                && id.equals(other.id)
                && resourceType.equals(other.resourceType)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.apiKeyId,
                this.createdAt,
                this.environmentId,
                this.expiredAt,
                this.id,
                this.resourceType,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ApiKeyIdStage builder() {
        return new Builder();
    }

    public interface ApiKeyIdStage {
        CreatedAtStage apiKeyId(@NotNull String apiKeyId);

        Builder from(TemporaryAccessTokenResponseData other);
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface EnvironmentIdStage {
        ExpiredAtStage environmentId(@NotNull String environmentId);
    }

    public interface ExpiredAtStage {
        IdStage expiredAt(@NotNull OffsetDateTime expiredAt);
    }

    public interface IdStage {
        ResourceTypeStage id(@NotNull String id);
    }

    public interface ResourceTypeStage {
        UpdatedAtStage resourceType(@NotNull String resourceType);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        TemporaryAccessTokenResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ApiKeyIdStage,
                    CreatedAtStage,
                    EnvironmentIdStage,
                    ExpiredAtStage,
                    IdStage,
                    ResourceTypeStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String apiKeyId;

        private OffsetDateTime createdAt;

        private String environmentId;

        private OffsetDateTime expiredAt;

        private String id;

        private String resourceType;

        private OffsetDateTime updatedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TemporaryAccessTokenResponseData other) {
            apiKeyId(other.getApiKeyId());
            createdAt(other.getCreatedAt());
            environmentId(other.getEnvironmentId());
            expiredAt(other.getExpiredAt());
            id(other.getId());
            resourceType(other.getResourceType());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("api_key_id")
        public CreatedAtStage apiKeyId(@NotNull String apiKeyId) {
            this.apiKeyId = Objects.requireNonNull(apiKeyId, "apiKeyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public ExpiredAtStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("expired_at")
        public IdStage expiredAt(@NotNull OffsetDateTime expiredAt) {
            this.expiredAt = Objects.requireNonNull(expiredAt, "expiredAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public ResourceTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("resource_type")
        public UpdatedAtStage resourceType(@NotNull String resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public TemporaryAccessTokenResponseData build() {
            return new TemporaryAccessTokenResponseData(
                    apiKeyId, createdAt, environmentId, expiredAt, id, resourceType, updatedAt, additionalProperties);
        }
    }
}
