/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdatePayInAdvanceRequestBody.Builder.class)
public final class UpdatePayInAdvanceRequestBody {
    private final String priceId;

    private final int quantity;

    private final Map<String, Object> additionalProperties;

    private UpdatePayInAdvanceRequestBody(String priceId, int quantity, Map<String, Object> additionalProperties) {
        this.priceId = priceId;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("price_id")
    public String getPriceId() {
        return priceId;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdatePayInAdvanceRequestBody && equalTo((UpdatePayInAdvanceRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePayInAdvanceRequestBody other) {
        return priceId.equals(other.priceId) && quantity == other.quantity;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.priceId, this.quantity);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PriceIdStage builder() {
        return new Builder();
    }

    public interface PriceIdStage {
        QuantityStage priceId(@NotNull String priceId);

        Builder from(UpdatePayInAdvanceRequestBody other);
    }

    public interface QuantityStage {
        _FinalStage quantity(int quantity);
    }

    public interface _FinalStage {
        UpdatePayInAdvanceRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PriceIdStage, QuantityStage, _FinalStage {
        private String priceId;

        private int quantity;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdatePayInAdvanceRequestBody other) {
            priceId(other.getPriceId());
            quantity(other.getQuantity());
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_id")
        public QuantityStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public UpdatePayInAdvanceRequestBody build() {
            return new UpdatePayInAdvanceRequestBody(priceId, quantity, additionalProperties);
        }
    }
}
