/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = WebhookEventDetailResponseData.Builder.class)
public final class WebhookEventDetailResponseData {
    private final OffsetDateTime createdAt;

    private final String id;

    private final Optional<String> payload;

    private final String requestType;

    private final Optional<Integer> responseCode;

    private final Optional<OffsetDateTime> sentAt;

    private final String status;

    private final OffsetDateTime updatedAt;

    private final Optional<WebhookResponseData> webhook;

    private final String webhookId;

    private final Map<String, Object> additionalProperties;

    private WebhookEventDetailResponseData(
            OffsetDateTime createdAt,
            String id,
            Optional<String> payload,
            String requestType,
            Optional<Integer> responseCode,
            Optional<OffsetDateTime> sentAt,
            String status,
            OffsetDateTime updatedAt,
            Optional<WebhookResponseData> webhook,
            String webhookId,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.id = id;
        this.payload = payload;
        this.requestType = requestType;
        this.responseCode = responseCode;
        this.sentAt = sentAt;
        this.status = status;
        this.updatedAt = updatedAt;
        this.webhook = webhook;
        this.webhookId = webhookId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("payload")
    public Optional<String> getPayload() {
        return payload;
    }

    @JsonProperty("request_type")
    public String getRequestType() {
        return requestType;
    }

    @JsonProperty("response_code")
    public Optional<Integer> getResponseCode() {
        return responseCode;
    }

    @JsonProperty("sent_at")
    public Optional<OffsetDateTime> getSentAt() {
        return sentAt;
    }

    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("webhook")
    public Optional<WebhookResponseData> getWebhook() {
        return webhook;
    }

    @JsonProperty("webhook_id")
    public String getWebhookId() {
        return webhookId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof WebhookEventDetailResponseData && equalTo((WebhookEventDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WebhookEventDetailResponseData other) {
        return createdAt.equals(other.createdAt)
                && id.equals(other.id)
                && payload.equals(other.payload)
                && requestType.equals(other.requestType)
                && responseCode.equals(other.responseCode)
                && sentAt.equals(other.sentAt)
                && status.equals(other.status)
                && updatedAt.equals(other.updatedAt)
                && webhook.equals(other.webhook)
                && webhookId.equals(other.webhookId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.id,
                this.payload,
                this.requestType,
                this.responseCode,
                this.sentAt,
                this.status,
                this.updatedAt,
                this.webhook,
                this.webhookId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        IdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(WebhookEventDetailResponseData other);
    }

    public interface IdStage {
        RequestTypeStage id(@NotNull String id);
    }

    public interface RequestTypeStage {
        StatusStage requestType(@NotNull String requestType);
    }

    public interface StatusStage {
        UpdatedAtStage status(@NotNull String status);
    }

    public interface UpdatedAtStage {
        WebhookIdStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface WebhookIdStage {
        _FinalStage webhookId(@NotNull String webhookId);
    }

    public interface _FinalStage {
        WebhookEventDetailResponseData build();

        _FinalStage payload(Optional<String> payload);

        _FinalStage payload(String payload);

        _FinalStage responseCode(Optional<Integer> responseCode);

        _FinalStage responseCode(Integer responseCode);

        _FinalStage sentAt(Optional<OffsetDateTime> sentAt);

        _FinalStage sentAt(OffsetDateTime sentAt);

        _FinalStage webhook(Optional<WebhookResponseData> webhook);

        _FinalStage webhook(WebhookResponseData webhook);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    IdStage,
                    RequestTypeStage,
                    StatusStage,
                    UpdatedAtStage,
                    WebhookIdStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String id;

        private String requestType;

        private String status;

        private OffsetDateTime updatedAt;

        private String webhookId;

        private Optional<WebhookResponseData> webhook = Optional.empty();

        private Optional<OffsetDateTime> sentAt = Optional.empty();

        private Optional<Integer> responseCode = Optional.empty();

        private Optional<String> payload = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(WebhookEventDetailResponseData other) {
            createdAt(other.getCreatedAt());
            id(other.getId());
            payload(other.getPayload());
            requestType(other.getRequestType());
            responseCode(other.getResponseCode());
            sentAt(other.getSentAt());
            status(other.getStatus());
            updatedAt(other.getUpdatedAt());
            webhook(other.getWebhook());
            webhookId(other.getWebhookId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public RequestTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("request_type")
        public StatusStage requestType(@NotNull String requestType) {
            this.requestType = Objects.requireNonNull(requestType, "requestType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public WebhookIdStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("webhook_id")
        public _FinalStage webhookId(@NotNull String webhookId) {
            this.webhookId = Objects.requireNonNull(webhookId, "webhookId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage webhook(WebhookResponseData webhook) {
            this.webhook = Optional.ofNullable(webhook);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook", nulls = Nulls.SKIP)
        public _FinalStage webhook(Optional<WebhookResponseData> webhook) {
            this.webhook = webhook;
            return this;
        }

        @java.lang.Override
        public _FinalStage sentAt(OffsetDateTime sentAt) {
            this.sentAt = Optional.ofNullable(sentAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sent_at", nulls = Nulls.SKIP)
        public _FinalStage sentAt(Optional<OffsetDateTime> sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage responseCode(Integer responseCode) {
            this.responseCode = Optional.ofNullable(responseCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "response_code", nulls = Nulls.SKIP)
        public _FinalStage responseCode(Optional<Integer> responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        @java.lang.Override
        public _FinalStage payload(String payload) {
            this.payload = Optional.ofNullable(payload);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payload", nulls = Nulls.SKIP)
        public _FinalStage payload(Optional<String> payload) {
            this.payload = payload;
            return this;
        }

        @java.lang.Override
        public WebhookEventDetailResponseData build() {
            return new WebhookEventDetailResponseData(
                    createdAt,
                    id,
                    payload,
                    requestType,
                    responseCode,
                    sentAt,
                    status,
                    updatedAt,
                    webhook,
                    webhookId,
                    additionalProperties);
        }
    }
}
