/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.accounts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountApiKeysParams {
    private final Optional<String> environmentId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<Boolean> requireEnvironment;
    private final Map<String, Object> additionalProperties;

    private CountApiKeysParams(Optional<String> environmentId, Optional<Integer> limit, Optional<Integer> offset, Optional<Boolean> requireEnvironment, Map<String, Object> additionalProperties) {
        this.environmentId = environmentId;
        this.limit = limit;
        this.offset = offset;
        this.requireEnvironment = requireEnvironment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="environment_id")
    public Optional<String> getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="require_environment")
    public Optional<Boolean> getRequireEnvironment() {
        return this.requireEnvironment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountApiKeysParams && this.equalTo((CountApiKeysParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountApiKeysParams other) {
        return this.environmentId.equals(other.environmentId) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.requireEnvironment.equals(other.requireEnvironment);
    }

    public int hashCode() {
        return Objects.hash(this.environmentId, this.limit, this.offset, this.requireEnvironment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> environmentId = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<Boolean> requireEnvironment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CountApiKeysParams other) {
            this.environmentId(other.getEnvironmentId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.requireEnvironment(other.getRequireEnvironment());
            return this;
        }

        @JsonSetter(value="environment_id", nulls=Nulls.SKIP)
        public Builder environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="require_environment", nulls=Nulls.SKIP)
        public Builder requireEnvironment(Optional<Boolean> requireEnvironment) {
            this.requireEnvironment = requireEnvironment;
            return this;
        }

        public Builder requireEnvironment(Boolean requireEnvironment) {
            this.requireEnvironment = Optional.ofNullable(requireEnvironment);
            return this;
        }

        public CountApiKeysParams build() {
            return new CountApiKeysParams(this.environmentId, this.limit, this.offset, this.requireEnvironment, this.additionalProperties);
        }
    }
}

