/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingProductRequestBody {
    private final String currency;
    private final String externalId;
    private final String name;
    private final double price;
    private final int quantity;
    private final Map<String, Object> additionalProperties;

    private CreateBillingProductRequestBody(String currency, String externalId, String name, double price, int quantity, Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.externalId = externalId;
        this.name = name;
        this.price = price;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price")
    public double getPrice() {
        return this.price;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingProductRequestBody && this.equalTo((CreateBillingProductRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingProductRequestBody other) {
        return this.currency.equals(other.currency) && this.externalId.equals(other.externalId) && this.name.equals(other.name) && this.price == other.price && this.quantity == other.quantity;
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.externalId, this.name, this.price, this.quantity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CurrencyStage,
    ExternalIdStage,
    NameStage,
    PriceStage,
    QuantityStage,
    _FinalStage {
        private String currency;
        private String externalId;
        private String name;
        private double price;
        private int quantity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingProductRequestBody other) {
            this.currency(other.getCurrency());
            this.externalId(other.getExternalId());
            this.name(other.getName());
            this.price(other.getPrice());
            this.quantity(other.getQuantity());
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public ExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public NameStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public QuantityStage price(double price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public CreateBillingProductRequestBody build() {
            return new CreateBillingProductRequestBody(this.currency, this.externalId, this.name, this.price, this.quantity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingProductRequestBody build();
    }

    public static interface QuantityStage {
        public _FinalStage quantity(int var1);
    }

    public static interface PriceStage {
        public QuantityStage price(double var1);
    }

    public static interface NameStage {
        public PriceStage name(@NotNull String var1);
    }

    public static interface ExternalIdStage {
        public NameStage externalId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public ExternalIdStage currency(@NotNull String var1);

        public Builder from(CreateBillingProductRequestBody var1);
    }
}

