/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.ListProductPricesRequestPriceUsageType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListProductPricesRequest {
    private final Optional<String> ids;
    private final Optional<String> name;
    private final Optional<String> q;
    private final Optional<ListProductPricesRequestPriceUsageType> priceUsageType;
    private final Optional<Boolean> withoutLinkedToPlan;
    private final Optional<Boolean> withZeroPrice;
    private final Optional<Boolean> withPricesOnly;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListProductPricesRequest(Optional<String> ids, Optional<String> name, Optional<String> q, Optional<ListProductPricesRequestPriceUsageType> priceUsageType, Optional<Boolean> withoutLinkedToPlan, Optional<Boolean> withZeroPrice, Optional<Boolean> withPricesOnly, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.name = name;
        this.q = q;
        this.priceUsageType = priceUsageType;
        this.withoutLinkedToPlan = withoutLinkedToPlan;
        this.withZeroPrice = withZeroPrice;
        this.withPricesOnly = withPricesOnly;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ids")
    public Optional<String> getIds() {
        return this.ids;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="price_usage_type")
    public Optional<ListProductPricesRequestPriceUsageType> getPriceUsageType() {
        return this.priceUsageType;
    }

    @JsonProperty(value="without_linked_to_plan")
    public Optional<Boolean> getWithoutLinkedToPlan() {
        return this.withoutLinkedToPlan;
    }

    @JsonProperty(value="with_zero_price")
    public Optional<Boolean> getWithZeroPrice() {
        return this.withZeroPrice;
    }

    @JsonProperty(value="with_prices_only")
    public Optional<Boolean> getWithPricesOnly() {
        return this.withPricesOnly;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListProductPricesRequest && this.equalTo((ListProductPricesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListProductPricesRequest other) {
        return this.ids.equals(other.ids) && this.name.equals(other.name) && this.q.equals(other.q) && this.priceUsageType.equals(other.priceUsageType) && this.withoutLinkedToPlan.equals(other.withoutLinkedToPlan) && this.withZeroPrice.equals(other.withZeroPrice) && this.withPricesOnly.equals(other.withPricesOnly) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.name, this.q, this.priceUsageType, this.withoutLinkedToPlan, this.withZeroPrice, this.withPricesOnly, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> ids = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<ListProductPricesRequestPriceUsageType> priceUsageType = Optional.empty();
        private Optional<Boolean> withoutLinkedToPlan = Optional.empty();
        private Optional<Boolean> withZeroPrice = Optional.empty();
        private Optional<Boolean> withPricesOnly = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListProductPricesRequest other) {
            this.ids(other.getIds());
            this.name(other.getName());
            this.q(other.getQ());
            this.priceUsageType(other.getPriceUsageType());
            this.withoutLinkedToPlan(other.getWithoutLinkedToPlan());
            this.withZeroPrice(other.getWithZeroPrice());
            this.withPricesOnly(other.getWithPricesOnly());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="price_usage_type", nulls=Nulls.SKIP)
        public Builder priceUsageType(Optional<ListProductPricesRequestPriceUsageType> priceUsageType) {
            this.priceUsageType = priceUsageType;
            return this;
        }

        public Builder priceUsageType(ListProductPricesRequestPriceUsageType priceUsageType) {
            this.priceUsageType = Optional.ofNullable(priceUsageType);
            return this;
        }

        @JsonSetter(value="without_linked_to_plan", nulls=Nulls.SKIP)
        public Builder withoutLinkedToPlan(Optional<Boolean> withoutLinkedToPlan) {
            this.withoutLinkedToPlan = withoutLinkedToPlan;
            return this;
        }

        public Builder withoutLinkedToPlan(Boolean withoutLinkedToPlan) {
            this.withoutLinkedToPlan = Optional.ofNullable(withoutLinkedToPlan);
            return this;
        }

        @JsonSetter(value="with_zero_price", nulls=Nulls.SKIP)
        public Builder withZeroPrice(Optional<Boolean> withZeroPrice) {
            this.withZeroPrice = withZeroPrice;
            return this;
        }

        public Builder withZeroPrice(Boolean withZeroPrice) {
            this.withZeroPrice = Optional.ofNullable(withZeroPrice);
            return this;
        }

        @JsonSetter(value="with_prices_only", nulls=Nulls.SKIP)
        public Builder withPricesOnly(Optional<Boolean> withPricesOnly) {
            this.withPricesOnly = withPricesOnly;
            return this;
        }

        public Builder withPricesOnly(Boolean withPricesOnly) {
            this.withPricesOnly = Optional.ofNullable(withPricesOnly);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListProductPricesRequest build() {
            return new ListProductPricesRequest(this.ids, this.name, this.q, this.priceUsageType, this.withoutLinkedToPlan, this.withZeroPrice, this.withPricesOnly, this.limit, this.offset, this.additionalProperties);
        }
    }
}

