/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchBillingPricesParams {
    private final Optional<List<String>> ids;
    private final Optional<String> interval;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<Integer> price;
    private final Optional<String> usageType;
    private final Map<String, Object> additionalProperties;

    private SearchBillingPricesParams(Optional<List<String>> ids, Optional<String> interval, Optional<Integer> limit, Optional<Integer> offset, Optional<Integer> price, Optional<String> usageType, Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.interval = interval;
        this.limit = limit;
        this.offset = offset;
        this.price = price;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="price")
    public Optional<Integer> getPrice() {
        return this.price;
    }

    @JsonProperty(value="usage_type")
    public Optional<String> getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchBillingPricesParams && this.equalTo((SearchBillingPricesParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchBillingPricesParams other) {
        return this.ids.equals(other.ids) && this.interval.equals(other.interval) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.price.equals(other.price) && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.interval, this.limit, this.offset, this.price, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();
        private Optional<String> interval = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> price = Optional.empty();
        private Optional<String> usageType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchBillingPricesParams other) {
            this.ids(other.getIds());
            this.interval(other.getInterval());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.price(other.getPrice());
            this.usageType(other.getUsageType());
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="interval", nulls=Nulls.SKIP)
        public Builder interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public Builder price(Optional<Integer> price) {
            this.price = price;
            return this;
        }

        public Builder price(Integer price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @JsonSetter(value="usage_type", nulls=Nulls.SKIP)
        public Builder usageType(Optional<String> usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder usageType(String usageType) {
            this.usageType = Optional.ofNullable(usageType);
            return this;
        }

        public SearchBillingPricesParams build() {
            return new SearchBillingPricesParams(this.ids, this.interval, this.limit, this.offset, this.price, this.usageType, this.additionalProperties);
        }
    }
}

