/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCrmLineItemRequestBody {
    private final String amount;
    private final Optional<String> discountPercentage;
    private final String interval;
    private final String lineItemExternalId;
    private final String productExternalId;
    private final int quantity;
    private final Optional<Integer> termMonth;
    private final Optional<String> totalDiscount;
    private final Map<String, Object> additionalProperties;

    private CreateCrmLineItemRequestBody(String amount, Optional<String> discountPercentage, String interval, String lineItemExternalId, String productExternalId, int quantity, Optional<Integer> termMonth, Optional<String> totalDiscount, Map<String, Object> additionalProperties) {
        this.amount = amount;
        this.discountPercentage = discountPercentage;
        this.interval = interval;
        this.lineItemExternalId = lineItemExternalId;
        this.productExternalId = productExternalId;
        this.quantity = quantity;
        this.termMonth = termMonth;
        this.totalDiscount = totalDiscount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount")
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="discount_percentage")
    public Optional<String> getDiscountPercentage() {
        return this.discountPercentage;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="line_item_external_id")
    public String getLineItemExternalId() {
        return this.lineItemExternalId;
    }

    @JsonProperty(value="product_external_id")
    public String getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="term_month")
    public Optional<Integer> getTermMonth() {
        return this.termMonth;
    }

    @JsonProperty(value="total_discount")
    public Optional<String> getTotalDiscount() {
        return this.totalDiscount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCrmLineItemRequestBody && this.equalTo((CreateCrmLineItemRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmLineItemRequestBody other) {
        return this.amount.equals(other.amount) && this.discountPercentage.equals(other.discountPercentage) && this.interval.equals(other.interval) && this.lineItemExternalId.equals(other.lineItemExternalId) && this.productExternalId.equals(other.productExternalId) && this.quantity == other.quantity && this.termMonth.equals(other.termMonth) && this.totalDiscount.equals(other.totalDiscount);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.discountPercentage, this.interval, this.lineItemExternalId, this.productExternalId, this.quantity, this.termMonth, this.totalDiscount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountStage,
    IntervalStage,
    LineItemExternalIdStage,
    ProductExternalIdStage,
    QuantityStage,
    _FinalStage {
        private String amount;
        private String interval;
        private String lineItemExternalId;
        private String productExternalId;
        private int quantity;
        private Optional<String> totalDiscount = Optional.empty();
        private Optional<Integer> termMonth = Optional.empty();
        private Optional<String> discountPercentage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCrmLineItemRequestBody other) {
            this.amount(other.getAmount());
            this.discountPercentage(other.getDiscountPercentage());
            this.interval(other.getInterval());
            this.lineItemExternalId(other.getLineItemExternalId());
            this.productExternalId(other.getProductExternalId());
            this.quantity(other.getQuantity());
            this.termMonth(other.getTermMonth());
            this.totalDiscount(other.getTotalDiscount());
            return this;
        }

        @Override
        @JsonSetter(value="amount")
        public IntervalStage amount(@NotNull String amount) {
            this.amount = Objects.requireNonNull(amount, "amount must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public LineItemExternalIdStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="line_item_external_id")
        public ProductExternalIdStage lineItemExternalId(@NotNull String lineItemExternalId) {
            this.lineItemExternalId = Objects.requireNonNull(lineItemExternalId, "lineItemExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id")
        public QuantityStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public _FinalStage totalDiscount(String totalDiscount) {
            this.totalDiscount = Optional.ofNullable(totalDiscount);
            return this;
        }

        @Override
        @JsonSetter(value="total_discount", nulls=Nulls.SKIP)
        public _FinalStage totalDiscount(Optional<String> totalDiscount) {
            this.totalDiscount = totalDiscount;
            return this;
        }

        @Override
        public _FinalStage termMonth(Integer termMonth) {
            this.termMonth = Optional.ofNullable(termMonth);
            return this;
        }

        @Override
        @JsonSetter(value="term_month", nulls=Nulls.SKIP)
        public _FinalStage termMonth(Optional<Integer> termMonth) {
            this.termMonth = termMonth;
            return this;
        }

        @Override
        public _FinalStage discountPercentage(String discountPercentage) {
            this.discountPercentage = Optional.ofNullable(discountPercentage);
            return this;
        }

        @Override
        @JsonSetter(value="discount_percentage", nulls=Nulls.SKIP)
        public _FinalStage discountPercentage(Optional<String> discountPercentage) {
            this.discountPercentage = discountPercentage;
            return this;
        }

        @Override
        public CreateCrmLineItemRequestBody build() {
            return new CreateCrmLineItemRequestBody(this.amount, this.discountPercentage, this.interval, this.lineItemExternalId, this.productExternalId, this.quantity, this.termMonth, this.totalDiscount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCrmLineItemRequestBody build();

        public _FinalStage discountPercentage(Optional<String> var1);

        public _FinalStage discountPercentage(String var1);

        public _FinalStage termMonth(Optional<Integer> var1);

        public _FinalStage termMonth(Integer var1);

        public _FinalStage totalDiscount(Optional<String> var1);

        public _FinalStage totalDiscount(String var1);
    }

    public static interface QuantityStage {
        public _FinalStage quantity(int var1);
    }

    public static interface ProductExternalIdStage {
        public QuantityStage productExternalId(@NotNull String var1);
    }

    public static interface LineItemExternalIdStage {
        public ProductExternalIdStage lineItemExternalId(@NotNull String var1);
    }

    public static interface IntervalStage {
        public LineItemExternalIdStage interval(@NotNull String var1);
    }

    public static interface AmountStage {
        public IntervalStage amount(@NotNull String var1);

        public Builder from(CreateCrmLineItemRequestBody var1);
    }
}

