/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.webhooks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.webhooks.requests.CountWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.CountWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.CreateWebhookRequestBody;
import com.schematic.api.resources.webhooks.requests.ListWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.ListWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.UpdateWebhookRequestBody;
import com.schematic.api.resources.webhooks.types.CountWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.CountWebhooksResponse;
import com.schematic.api.resources.webhooks.types.CreateWebhookResponse;
import com.schematic.api.resources.webhooks.types.DeleteWebhookResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookEventResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookResponse;
import com.schematic.api.resources.webhooks.types.ListWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.ListWebhooksResponse;
import com.schematic.api.resources.webhooks.types.UpdateWebhookResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class WebhooksClient {
    protected final ClientOptions clientOptions;

    public WebhooksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ListWebhookEventsResponse listWebhookEvents() {
        return this.listWebhookEvents(ListWebhookEventsRequest.builder().build());
    }

    public ListWebhookEventsResponse listWebhookEvents(ListWebhookEventsRequest request) {
        return this.listWebhookEvents(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListWebhookEventsResponse listWebhookEvents(ListWebhookEventsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhook-events");
        if (request.getIds().isPresent()) {
            httpUrl.addQueryParameter("ids", request.getIds().get());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getWebhookId().isPresent()) {
            httpUrl.addQueryParameter("webhook_id", request.getWebhookId().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListWebhookEventsResponse listWebhookEventsResponse = (ListWebhookEventsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListWebhookEventsResponse.class);
                return listWebhookEventsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public GetWebhookEventResponse getWebhookEvent(String webhookEventId) {
        return this.getWebhookEvent(webhookEventId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetWebhookEventResponse getWebhookEvent(String webhookEventId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhook-events").addPathSegment(webhookEventId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetWebhookEventResponse getWebhookEventResponse = (GetWebhookEventResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetWebhookEventResponse.class);
                return getWebhookEventResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public CountWebhookEventsResponse countWebhookEvents() {
        return this.countWebhookEvents(CountWebhookEventsRequest.builder().build());
    }

    public CountWebhookEventsResponse countWebhookEvents(CountWebhookEventsRequest request) {
        return this.countWebhookEvents(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CountWebhookEventsResponse countWebhookEvents(CountWebhookEventsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhook-events/count");
        if (request.getIds().isPresent()) {
            httpUrl.addQueryParameter("ids", request.getIds().get());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getWebhookId().isPresent()) {
            httpUrl.addQueryParameter("webhook_id", request.getWebhookId().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CountWebhookEventsResponse countWebhookEventsResponse = (CountWebhookEventsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountWebhookEventsResponse.class);
                return countWebhookEventsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListWebhooksResponse listWebhooks() {
        return this.listWebhooks(ListWebhooksRequest.builder().build());
    }

    public ListWebhooksResponse listWebhooks(ListWebhooksRequest request) {
        return this.listWebhooks(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListWebhooksResponse listWebhooks(ListWebhooksRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks");
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListWebhooksResponse listWebhooksResponse = (ListWebhooksResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListWebhooksResponse.class);
                return listWebhooksResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public CreateWebhookResponse createWebhook(CreateWebhookRequestBody request) {
        return this.createWebhook(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateWebhookResponse createWebhook(CreateWebhookRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CreateWebhookResponse createWebhookResponse = (CreateWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateWebhookResponse.class);
                return createWebhookResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public GetWebhookResponse getWebhook(String webhookId) {
        return this.getWebhook(webhookId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetWebhookResponse getWebhook(String webhookId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").addPathSegment(webhookId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetWebhookResponse getWebhookResponse = (GetWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetWebhookResponse.class);
                return getWebhookResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpdateWebhookResponse updateWebhook(String webhookId) {
        return this.updateWebhook(webhookId, UpdateWebhookRequestBody.builder().build());
    }

    public UpdateWebhookResponse updateWebhook(String webhookId, UpdateWebhookRequestBody request) {
        return this.updateWebhook(webhookId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpdateWebhookResponse updateWebhook(String webhookId, UpdateWebhookRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").addPathSegment(webhookId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpdateWebhookResponse updateWebhookResponse = (UpdateWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateWebhookResponse.class);
                return updateWebhookResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public DeleteWebhookResponse deleteWebhook(String webhookId) {
        return this.deleteWebhook(webhookId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteWebhookResponse deleteWebhook(String webhookId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").addPathSegment(webhookId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DeleteWebhookResponse deleteWebhookResponse = (DeleteWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteWebhookResponse.class);
                return deleteWebhookResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public CountWebhooksResponse countWebhooks() {
        return this.countWebhooks(CountWebhooksRequest.builder().build());
    }

    public CountWebhooksResponse countWebhooks(CountWebhooksRequest request) {
        return this.countWebhooks(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CountWebhooksResponse countWebhooks(CountWebhooksRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks/count");
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CountWebhooksResponse countWebhooksResponse = (CountWebhooksResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountWebhooksResponse.class);
                return countWebhooksResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

