/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingPriceResponseData {
    private final String currency;
    private final String externalPriceId;
    private final String id;
    private final String interval;
    private final int price;
    private final Map<String, Object> additionalProperties;

    private BillingPriceResponseData(String currency, String externalPriceId, String id, String interval, int price, Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.externalPriceId = externalPriceId;
        this.id = id;
        this.interval = interval;
        this.price = price;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="external_price_id")
    public String getExternalPriceId() {
        return this.externalPriceId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingPriceResponseData && this.equalTo((BillingPriceResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingPriceResponseData other) {
        return this.currency.equals(other.currency) && this.externalPriceId.equals(other.externalPriceId) && this.id.equals(other.id) && this.interval.equals(other.interval) && this.price == other.price;
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.externalPriceId, this.id, this.interval, this.price);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CurrencyStage,
    ExternalPriceIdStage,
    IdStage,
    IntervalStage,
    PriceStage,
    _FinalStage {
        private String currency;
        private String externalPriceId;
        private String id;
        private String interval;
        private int price;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingPriceResponseData other) {
            this.currency(other.getCurrency());
            this.externalPriceId(other.getExternalPriceId());
            this.id(other.getId());
            this.interval(other.getInterval());
            this.price(other.getPrice());
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public ExternalPriceIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_price_id")
        public IdStage externalPriceId(@NotNull String externalPriceId) {
            this.externalPriceId = Objects.requireNonNull(externalPriceId, "externalPriceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public PriceStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public _FinalStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        public BillingPriceResponseData build() {
            return new BillingPriceResponseData(this.currency, this.externalPriceId, this.id, this.interval, this.price, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingPriceResponseData build();
    }

    public static interface PriceStage {
        public _FinalStage price(int var1);
    }

    public static interface IntervalStage {
        public PriceStage interval(@NotNull String var1);
    }

    public static interface IdStage {
        public IntervalStage id(@NotNull String var1);
    }

    public static interface ExternalPriceIdStage {
        public IdStage externalPriceId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public ExternalPriceIdStage currency(@NotNull String var1);

        public Builder from(BillingPriceResponseData var1);
    }
}

