/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingSubscriptionResponseData {
    private final Optional<String> companyId;
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String customerExternalId;
    private final Optional<OffsetDateTime> expiredAt;
    private final String id;
    private final String interval;
    private final Optional<Map<String, JsonNode>> metadata;
    private final int periodEnd;
    private final int periodStart;
    private final String status;
    private final String subscriptionExternalId;
    private final int totalPrice;
    private final Optional<Integer> trialEnd;
    private final Optional<String> trialEndSetting;
    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionResponseData(Optional<String> companyId, OffsetDateTime createdAt, String currency, String customerExternalId, Optional<OffsetDateTime> expiredAt, String id, String interval, Optional<Map<String, JsonNode>> metadata, int periodEnd, int periodStart, String status, String subscriptionExternalId, int totalPrice, Optional<Integer> trialEnd, Optional<String> trialEndSetting, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.expiredAt = expiredAt;
        this.id = id;
        this.interval = interval;
        this.metadata = metadata;
        this.periodEnd = periodEnd;
        this.periodStart = periodStart;
        this.status = status;
        this.subscriptionExternalId = subscriptionExternalId;
        this.totalPrice = totalPrice;
        this.trialEnd = trialEnd;
        this.trialEndSetting = trialEndSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="metadata")
    public Optional<Map<String, JsonNode>> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="period_end")
    public int getPeriodEnd() {
        return this.periodEnd;
    }

    @JsonProperty(value="period_start")
    public int getPeriodStart() {
        return this.periodStart;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="subscription_external_id")
    public String getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    @JsonProperty(value="total_price")
    public int getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="trial_end")
    public Optional<Integer> getTrialEnd() {
        return this.trialEnd;
    }

    @JsonProperty(value="trial_end_setting")
    public Optional<String> getTrialEndSetting() {
        return this.trialEndSetting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingSubscriptionResponseData && this.equalTo((BillingSubscriptionResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionResponseData other) {
        return this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.customerExternalId.equals(other.customerExternalId) && this.expiredAt.equals(other.expiredAt) && this.id.equals(other.id) && this.interval.equals(other.interval) && this.metadata.equals(other.metadata) && this.periodEnd == other.periodEnd && this.periodStart == other.periodStart && this.status.equals(other.status) && this.subscriptionExternalId.equals(other.subscriptionExternalId) && this.totalPrice == other.totalPrice && this.trialEnd.equals(other.trialEnd) && this.trialEndSetting.equals(other.trialEndSetting);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.createdAt, this.currency, this.customerExternalId, this.expiredAt, this.id, this.interval, this.metadata, this.periodEnd, this.periodStart, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.trialEndSetting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    CurrencyStage,
    CustomerExternalIdStage,
    IdStage,
    IntervalStage,
    PeriodEndStage,
    PeriodStartStage,
    StatusStage,
    SubscriptionExternalIdStage,
    TotalPriceStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String currency;
        private String customerExternalId;
        private String id;
        private String interval;
        private int periodEnd;
        private int periodStart;
        private String status;
        private String subscriptionExternalId;
        private int totalPrice;
        private Optional<String> trialEndSetting = Optional.empty();
        private Optional<Integer> trialEnd = Optional.empty();
        private Optional<Map<String, JsonNode>> metadata = Optional.empty();
        private Optional<OffsetDateTime> expiredAt = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingSubscriptionResponseData other) {
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.customerExternalId(other.getCustomerExternalId());
            this.expiredAt(other.getExpiredAt());
            this.id(other.getId());
            this.interval(other.getInterval());
            this.metadata(other.getMetadata());
            this.periodEnd(other.getPeriodEnd());
            this.periodStart(other.getPeriodStart());
            this.status(other.getStatus());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            this.totalPrice(other.getTotalPrice());
            this.trialEnd(other.getTrialEnd());
            this.trialEndSetting(other.getTrialEndSetting());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public IdStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public PeriodEndStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="period_end")
        public PeriodStartStage periodEnd(int periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        @Override
        @JsonSetter(value="period_start")
        public StatusStage periodStart(int periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public SubscriptionExternalIdStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id")
        public TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId = Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage trialEndSetting(String trialEndSetting) {
            this.trialEndSetting = Optional.ofNullable(trialEndSetting);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end_setting", nulls=Nulls.SKIP)
        public _FinalStage trialEndSetting(Optional<String> trialEndSetting) {
            this.trialEndSetting = trialEndSetting;
            return this;
        }

        @Override
        public _FinalStage trialEnd(Integer trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end", nulls=Nulls.SKIP)
        public _FinalStage trialEnd(Optional<Integer> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, JsonNode> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, JsonNode>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @Override
        @JsonSetter(value="expired_at", nulls=Nulls.SKIP)
        public _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public BillingSubscriptionResponseData build() {
            return new BillingSubscriptionResponseData(this.companyId, this.createdAt, this.currency, this.customerExternalId, this.expiredAt, this.id, this.interval, this.metadata, this.periodEnd, this.periodStart, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.trialEndSetting, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingSubscriptionResponseData build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage expiredAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiredAt(OffsetDateTime var1);

        public _FinalStage metadata(Optional<Map<String, JsonNode>> var1);

        public _FinalStage metadata(Map<String, JsonNode> var1);

        public _FinalStage trialEnd(Optional<Integer> var1);

        public _FinalStage trialEnd(Integer var1);

        public _FinalStage trialEndSetting(Optional<String> var1);

        public _FinalStage trialEndSetting(String var1);
    }

    public static interface TotalPriceStage {
        public _FinalStage totalPrice(int var1);
    }

    public static interface SubscriptionExternalIdStage {
        public TotalPriceStage subscriptionExternalId(@NotNull String var1);
    }

    public static interface StatusStage {
        public SubscriptionExternalIdStage status(@NotNull String var1);
    }

    public static interface PeriodStartStage {
        public StatusStage periodStart(int var1);
    }

    public static interface PeriodEndStage {
        public PeriodStartStage periodEnd(int var1);
    }

    public static interface IntervalStage {
        public PeriodEndStage interval(@NotNull String var1);
    }

    public static interface IdStage {
        public IntervalStage id(@NotNull String var1);
    }

    public static interface CustomerExternalIdStage {
        public IdStage customerExternalId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public CustomerExternalIdStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(BillingSubscriptionResponseData var1);
    }
}

