/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceResponseData {
    private final int amountDue;
    private final int amountPaid;
    private final int amountRemaining;
    private final String collectionMethod;
    private final Optional<String> companyId;
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String customerExternalId;
    private final Optional<OffsetDateTime> dueDate;
    private final String environmentId;
    private final Optional<String> externalId;
    private final String id;
    private final Optional<String> paymentMethodExternalId;
    private final Optional<String> subscriptionExternalId;
    private final int subtotal;
    private final OffsetDateTime updatedAt;
    private final Optional<String> url;
    private final Map<String, Object> additionalProperties;

    private InvoiceResponseData(int amountDue, int amountPaid, int amountRemaining, String collectionMethod, Optional<String> companyId, OffsetDateTime createdAt, String currency, String customerExternalId, Optional<OffsetDateTime> dueDate, String environmentId, Optional<String> externalId, String id, Optional<String> paymentMethodExternalId, Optional<String> subscriptionExternalId, int subtotal, OffsetDateTime updatedAt, Optional<String> url, Map<String, Object> additionalProperties) {
        this.amountDue = amountDue;
        this.amountPaid = amountPaid;
        this.amountRemaining = amountRemaining;
        this.collectionMethod = collectionMethod;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.dueDate = dueDate;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.id = id;
        this.paymentMethodExternalId = paymentMethodExternalId;
        this.subscriptionExternalId = subscriptionExternalId;
        this.subtotal = subtotal;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_due")
    public int getAmountDue() {
        return this.amountDue;
    }

    @JsonProperty(value="amount_paid")
    public int getAmountPaid() {
        return this.amountPaid;
    }

    @JsonProperty(value="amount_remaining")
    public int getAmountRemaining() {
        return this.amountRemaining;
    }

    @JsonProperty(value="collection_method")
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="due_date")
    public Optional<OffsetDateTime> getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="payment_method_external_id")
    public Optional<String> getPaymentMethodExternalId() {
        return this.paymentMethodExternalId;
    }

    @JsonProperty(value="subscription_external_id")
    public Optional<String> getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    @JsonProperty(value="subtotal")
    public int getSubtotal() {
        return this.subtotal;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceResponseData && this.equalTo((InvoiceResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceResponseData other) {
        return this.amountDue == other.amountDue && this.amountPaid == other.amountPaid && this.amountRemaining == other.amountRemaining && this.collectionMethod.equals(other.collectionMethod) && this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.customerExternalId.equals(other.customerExternalId) && this.dueDate.equals(other.dueDate) && this.environmentId.equals(other.environmentId) && this.externalId.equals(other.externalId) && this.id.equals(other.id) && this.paymentMethodExternalId.equals(other.paymentMethodExternalId) && this.subscriptionExternalId.equals(other.subscriptionExternalId) && this.subtotal == other.subtotal && this.updatedAt.equals(other.updatedAt) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.amountDue, this.amountPaid, this.amountRemaining, this.collectionMethod, this.companyId, this.createdAt, this.currency, this.customerExternalId, this.dueDate, this.environmentId, this.externalId, this.id, this.paymentMethodExternalId, this.subscriptionExternalId, this.subtotal, this.updatedAt, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountDueStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountDueStage,
    AmountPaidStage,
    AmountRemainingStage,
    CollectionMethodStage,
    CreatedAtStage,
    CurrencyStage,
    CustomerExternalIdStage,
    EnvironmentIdStage,
    IdStage,
    SubtotalStage,
    UpdatedAtStage,
    _FinalStage {
        private int amountDue;
        private int amountPaid;
        private int amountRemaining;
        private String collectionMethod;
        private OffsetDateTime createdAt;
        private String currency;
        private String customerExternalId;
        private String environmentId;
        private String id;
        private int subtotal;
        private OffsetDateTime updatedAt;
        private Optional<String> url = Optional.empty();
        private Optional<String> subscriptionExternalId = Optional.empty();
        private Optional<String> paymentMethodExternalId = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<OffsetDateTime> dueDate = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(InvoiceResponseData other) {
            this.amountDue(other.getAmountDue());
            this.amountPaid(other.getAmountPaid());
            this.amountRemaining(other.getAmountRemaining());
            this.collectionMethod(other.getCollectionMethod());
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.customerExternalId(other.getCustomerExternalId());
            this.dueDate(other.getDueDate());
            this.environmentId(other.getEnvironmentId());
            this.externalId(other.getExternalId());
            this.id(other.getId());
            this.paymentMethodExternalId(other.getPaymentMethodExternalId());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            this.subtotal(other.getSubtotal());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="amount_due")
        public AmountPaidStage amountDue(int amountDue) {
            this.amountDue = amountDue;
            return this;
        }

        @Override
        @JsonSetter(value="amount_paid")
        public AmountRemainingStage amountPaid(int amountPaid) {
            this.amountPaid = amountPaid;
            return this;
        }

        @Override
        @JsonSetter(value="amount_remaining")
        public CollectionMethodStage amountRemaining(int amountRemaining) {
            this.amountRemaining = amountRemaining;
            return this;
        }

        @Override
        @JsonSetter(value="collection_method")
        public CreatedAtStage collectionMethod(@NotNull String collectionMethod) {
            this.collectionMethod = Objects.requireNonNull(collectionMethod, "collectionMethod must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public EnvironmentIdStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public SubtotalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subtotal")
        public UpdatedAtStage subtotal(int subtotal) {
            this.subtotal = subtotal;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage subscriptionExternalId(String subscriptionExternalId) {
            this.subscriptionExternalId = Optional.ofNullable(subscriptionExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id", nulls=Nulls.SKIP)
        public _FinalStage subscriptionExternalId(Optional<String> subscriptionExternalId) {
            this.subscriptionExternalId = subscriptionExternalId;
            return this;
        }

        @Override
        public _FinalStage paymentMethodExternalId(String paymentMethodExternalId) {
            this.paymentMethodExternalId = Optional.ofNullable(paymentMethodExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_method_external_id", nulls=Nulls.SKIP)
        public _FinalStage paymentMethodExternalId(Optional<String> paymentMethodExternalId) {
            this.paymentMethodExternalId = paymentMethodExternalId;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage dueDate(OffsetDateTime dueDate) {
            this.dueDate = Optional.ofNullable(dueDate);
            return this;
        }

        @Override
        @JsonSetter(value="due_date", nulls=Nulls.SKIP)
        public _FinalStage dueDate(Optional<OffsetDateTime> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public InvoiceResponseData build() {
            return new InvoiceResponseData(this.amountDue, this.amountPaid, this.amountRemaining, this.collectionMethod, this.companyId, this.createdAt, this.currency, this.customerExternalId, this.dueDate, this.environmentId, this.externalId, this.id, this.paymentMethodExternalId, this.subscriptionExternalId, this.subtotal, this.updatedAt, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public InvoiceResponseData build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage dueDate(Optional<OffsetDateTime> var1);

        public _FinalStage dueDate(OffsetDateTime var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);

        public _FinalStage paymentMethodExternalId(Optional<String> var1);

        public _FinalStage paymentMethodExternalId(String var1);

        public _FinalStage subscriptionExternalId(Optional<String> var1);

        public _FinalStage subscriptionExternalId(String var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface SubtotalStage {
        public UpdatedAtStage subtotal(int var1);
    }

    public static interface IdStage {
        public SubtotalStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CustomerExternalIdStage {
        public EnvironmentIdStage customerExternalId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public CustomerExternalIdStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CollectionMethodStage {
        public CreatedAtStage collectionMethod(@NotNull String var1);
    }

    public static interface AmountRemainingStage {
        public CollectionMethodStage amountRemaining(int var1);
    }

    public static interface AmountPaidStage {
        public AmountRemainingStage amountPaid(int var1);
    }

    public static interface AmountDueStage {
        public AmountPaidStage amountDue(int var1);

        public Builder from(InvoiceResponseData var1);
    }
}

