/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.Environment;
import okhttp3.OkHttpClient;

public final class BaseSchematicBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();

    private String apiKey = null;

    private Environment environment = Environment.DEFAULT;

    /**
     * Sets apiKey
     */
    public BaseSchematicBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public BaseSchematicBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public BaseSchematicBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    /**
     * Sets the timeout (in seconds) for the client
     */
    public BaseSchematicBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    /**
     * Sets the underlying OkHttp client
     */
    public BaseSchematicBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public BaseSchematic build() {
        if (apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("X-Schematic-Api-Key", this.apiKey);
        clientOptionsBuilder.environment(this.environment);
        return new BaseSchematic(clientOptionsBuilder.build());
    }
}
