/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateBillingCustomerRequestBody.Builder.class)
public final class CreateBillingCustomerRequestBody {
    private final Optional<String> companyId;

    private final Optional<String> defaultPaymentMethodId;

    private final String email;

    private final String externalId;

    private final boolean failedToImport;

    private final Map<String, String> meta;

    private final String name;

    private final Map<String, Object> additionalProperties;

    private CreateBillingCustomerRequestBody(
            Optional<String> companyId,
            Optional<String> defaultPaymentMethodId,
            String email,
            String externalId,
            boolean failedToImport,
            Map<String, String> meta,
            String name,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        this.email = email;
        this.externalId = externalId;
        this.failedToImport = failedToImport;
        this.meta = meta;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("default_payment_method_id")
    public Optional<String> getDefaultPaymentMethodId() {
        return defaultPaymentMethodId;
    }

    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("failed_to_import")
    public boolean getFailedToImport() {
        return failedToImport;
    }

    @JsonProperty("meta")
    public Map<String, String> getMeta() {
        return meta;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateBillingCustomerRequestBody && equalTo((CreateBillingCustomerRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingCustomerRequestBody other) {
        return companyId.equals(other.companyId)
                && defaultPaymentMethodId.equals(other.defaultPaymentMethodId)
                && email.equals(other.email)
                && externalId.equals(other.externalId)
                && failedToImport == other.failedToImport
                && meta.equals(other.meta)
                && name.equals(other.name);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId,
                this.defaultPaymentMethodId,
                this.email,
                this.externalId,
                this.failedToImport,
                this.meta,
                this.name);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    public interface EmailStage {
        ExternalIdStage email(@NotNull String email);

        Builder from(CreateBillingCustomerRequestBody other);
    }

    public interface ExternalIdStage {
        FailedToImportStage externalId(@NotNull String externalId);
    }

    public interface FailedToImportStage {
        NameStage failedToImport(boolean failedToImport);
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        CreateBillingCustomerRequestBody build();

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId);

        _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId);

        _FinalStage meta(Map<String, String> meta);

        _FinalStage putAllMeta(Map<String, String> meta);

        _FinalStage meta(String key, String value);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements EmailStage, ExternalIdStage, FailedToImportStage, NameStage, _FinalStage {
        private String email;

        private String externalId;

        private boolean failedToImport;

        private String name;

        private Map<String, String> meta = new LinkedHashMap<>();

        private Optional<String> defaultPaymentMethodId = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateBillingCustomerRequestBody other) {
            companyId(other.getCompanyId());
            defaultPaymentMethodId(other.getDefaultPaymentMethodId());
            email(other.getEmail());
            externalId(other.getExternalId());
            failedToImport(other.getFailedToImport());
            meta(other.getMeta());
            name(other.getName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("email")
        public ExternalIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public FailedToImportStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("failed_to_import")
        public NameStage failedToImport(boolean failedToImport) {
            this.failedToImport = failedToImport;
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage meta(String key, String value) {
            this.meta.put(key, value);
            return this;
        }

        @java.lang.Override
        public _FinalStage putAllMeta(Map<String, String> meta) {
            this.meta.putAll(meta);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "meta", nulls = Nulls.SKIP)
        public _FinalStage meta(Map<String, String> meta) {
            this.meta.clear();
            this.meta.putAll(meta);
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId) {
            this.defaultPaymentMethodId = Optional.ofNullable(defaultPaymentMethodId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_payment_method_id", nulls = Nulls.SKIP)
        public _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId) {
            this.defaultPaymentMethodId = defaultPaymentMethodId;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public CreateBillingCustomerRequestBody build() {
            return new CreateBillingCustomerRequestBody(
                    companyId,
                    defaultPaymentMethodId,
                    email,
                    externalId,
                    failedToImport,
                    meta,
                    name,
                    additionalProperties);
        }
    }
}
