/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListPaymentMethodsRequest.Builder.class)
public final class ListPaymentMethodsRequest {
    private final Optional<String> companyId;

    private final String customerExternalId;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListPaymentMethodsRequest(
            Optional<String> companyId,
            String customerExternalId,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.customerExternalId = customerExternalId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("customer_external_id")
    public String getCustomerExternalId() {
        return customerExternalId;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListPaymentMethodsRequest && equalTo((ListPaymentMethodsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPaymentMethodsRequest other) {
        return companyId.equals(other.companyId)
                && customerExternalId.equals(other.customerExternalId)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.customerExternalId, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerExternalIdStage builder() {
        return new Builder();
    }

    public interface CustomerExternalIdStage {
        _FinalStage customerExternalId(@NotNull String customerExternalId);

        Builder from(ListPaymentMethodsRequest other);
    }

    public interface _FinalStage {
        ListPaymentMethodsRequest build();

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage limit(Optional<Integer> limit);

        _FinalStage limit(Integer limit);

        _FinalStage offset(Optional<Integer> offset);

        _FinalStage offset(Integer offset);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CustomerExternalIdStage, _FinalStage {
        private String customerExternalId;

        private Optional<Integer> offset = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ListPaymentMethodsRequest other) {
            companyId(other.getCompanyId());
            customerExternalId(other.getCustomerExternalId());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @java.lang.Override
        @JsonSetter("customer_external_id")
        public _FinalStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public ListPaymentMethodsRequest build() {
            return new ListPaymentMethodsRequest(companyId, customerExternalId, limit, offset, additionalProperties);
        }
    }
}
