/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.entitlements.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.entitlements.types.CreateCompanyOverrideRequestBodyMetricPeriod;
import com.schematic.api.resources.entitlements.types.CreateCompanyOverrideRequestBodyMetricPeriodMonthReset;
import com.schematic.api.resources.entitlements.types.CreateCompanyOverrideRequestBodyValueType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCompanyOverrideRequestBody.Builder.class)
public final class CreateCompanyOverrideRequestBody {
    private final String companyId;

    private final Optional<OffsetDateTime> expirationDate;

    private final String featureId;

    private final Optional<CreateCompanyOverrideRequestBodyMetricPeriod> metricPeriod;

    private final Optional<CreateCompanyOverrideRequestBodyMetricPeriodMonthReset> metricPeriodMonthReset;

    private final Optional<Boolean> valueBool;

    private final Optional<Integer> valueNumeric;

    private final Optional<String> valueTraitId;

    private final CreateCompanyOverrideRequestBodyValueType valueType;

    private final Map<String, Object> additionalProperties;

    private CreateCompanyOverrideRequestBody(
            String companyId,
            Optional<OffsetDateTime> expirationDate,
            String featureId,
            Optional<CreateCompanyOverrideRequestBodyMetricPeriod> metricPeriod,
            Optional<CreateCompanyOverrideRequestBodyMetricPeriodMonthReset> metricPeriodMonthReset,
            Optional<Boolean> valueBool,
            Optional<Integer> valueNumeric,
            Optional<String> valueTraitId,
            CreateCompanyOverrideRequestBodyValueType valueType,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.expirationDate = expirationDate;
        this.featureId = featureId;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.valueBool = valueBool;
        this.valueNumeric = valueNumeric;
        this.valueTraitId = valueTraitId;
        this.valueType = valueType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("expiration_date")
    public Optional<OffsetDateTime> getExpirationDate() {
        return expirationDate;
    }

    @JsonProperty("feature_id")
    public String getFeatureId() {
        return featureId;
    }

    @JsonProperty("metric_period")
    public Optional<CreateCompanyOverrideRequestBodyMetricPeriod> getMetricPeriod() {
        return metricPeriod;
    }

    @JsonProperty("metric_period_month_reset")
    public Optional<CreateCompanyOverrideRequestBodyMetricPeriodMonthReset> getMetricPeriodMonthReset() {
        return metricPeriodMonthReset;
    }

    @JsonProperty("value_bool")
    public Optional<Boolean> getValueBool() {
        return valueBool;
    }

    @JsonProperty("value_numeric")
    public Optional<Integer> getValueNumeric() {
        return valueNumeric;
    }

    @JsonProperty("value_trait_id")
    public Optional<String> getValueTraitId() {
        return valueTraitId;
    }

    @JsonProperty("value_type")
    public CreateCompanyOverrideRequestBodyValueType getValueType() {
        return valueType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCompanyOverrideRequestBody && equalTo((CreateCompanyOverrideRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCompanyOverrideRequestBody other) {
        return companyId.equals(other.companyId)
                && expirationDate.equals(other.expirationDate)
                && featureId.equals(other.featureId)
                && metricPeriod.equals(other.metricPeriod)
                && metricPeriodMonthReset.equals(other.metricPeriodMonthReset)
                && valueBool.equals(other.valueBool)
                && valueNumeric.equals(other.valueNumeric)
                && valueTraitId.equals(other.valueTraitId)
                && valueType.equals(other.valueType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId,
                this.expirationDate,
                this.featureId,
                this.metricPeriod,
                this.metricPeriodMonthReset,
                this.valueBool,
                this.valueNumeric,
                this.valueTraitId,
                this.valueType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        FeatureIdStage companyId(@NotNull String companyId);

        Builder from(CreateCompanyOverrideRequestBody other);
    }

    public interface FeatureIdStage {
        ValueTypeStage featureId(@NotNull String featureId);
    }

    public interface ValueTypeStage {
        _FinalStage valueType(@NotNull CreateCompanyOverrideRequestBodyValueType valueType);
    }

    public interface _FinalStage {
        CreateCompanyOverrideRequestBody build();

        _FinalStage expirationDate(Optional<OffsetDateTime> expirationDate);

        _FinalStage expirationDate(OffsetDateTime expirationDate);

        _FinalStage metricPeriod(Optional<CreateCompanyOverrideRequestBodyMetricPeriod> metricPeriod);

        _FinalStage metricPeriod(CreateCompanyOverrideRequestBodyMetricPeriod metricPeriod);

        _FinalStage metricPeriodMonthReset(
                Optional<CreateCompanyOverrideRequestBodyMetricPeriodMonthReset> metricPeriodMonthReset);

        _FinalStage metricPeriodMonthReset(
                CreateCompanyOverrideRequestBodyMetricPeriodMonthReset metricPeriodMonthReset);

        _FinalStage valueBool(Optional<Boolean> valueBool);

        _FinalStage valueBool(Boolean valueBool);

        _FinalStage valueNumeric(Optional<Integer> valueNumeric);

        _FinalStage valueNumeric(Integer valueNumeric);

        _FinalStage valueTraitId(Optional<String> valueTraitId);

        _FinalStage valueTraitId(String valueTraitId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CompanyIdStage, FeatureIdStage, ValueTypeStage, _FinalStage {
        private String companyId;

        private String featureId;

        private CreateCompanyOverrideRequestBodyValueType valueType;

        private Optional<String> valueTraitId = Optional.empty();

        private Optional<Integer> valueNumeric = Optional.empty();

        private Optional<Boolean> valueBool = Optional.empty();

        private Optional<CreateCompanyOverrideRequestBodyMetricPeriodMonthReset> metricPeriodMonthReset =
                Optional.empty();

        private Optional<CreateCompanyOverrideRequestBodyMetricPeriod> metricPeriod = Optional.empty();

        private Optional<OffsetDateTime> expirationDate = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCompanyOverrideRequestBody other) {
            companyId(other.getCompanyId());
            expirationDate(other.getExpirationDate());
            featureId(other.getFeatureId());
            metricPeriod(other.getMetricPeriod());
            metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            valueBool(other.getValueBool());
            valueNumeric(other.getValueNumeric());
            valueTraitId(other.getValueTraitId());
            valueType(other.getValueType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public FeatureIdStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_id")
        public ValueTypeStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value_type")
        public _FinalStage valueType(@NotNull CreateCompanyOverrideRequestBodyValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage valueTraitId(String valueTraitId) {
            this.valueTraitId = Optional.ofNullable(valueTraitId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_trait_id", nulls = Nulls.SKIP)
        public _FinalStage valueTraitId(Optional<String> valueTraitId) {
            this.valueTraitId = valueTraitId;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_numeric", nulls = Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_bool", nulls = Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriodMonthReset(
                CreateCompanyOverrideRequestBodyMetricPeriodMonthReset metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period_month_reset", nulls = Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(
                Optional<CreateCompanyOverrideRequestBodyMetricPeriodMonthReset> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriod(CreateCompanyOverrideRequestBodyMetricPeriod metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period", nulls = Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<CreateCompanyOverrideRequestBodyMetricPeriod> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @java.lang.Override
        public _FinalStage expirationDate(OffsetDateTime expirationDate) {
            this.expirationDate = Optional.ofNullable(expirationDate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiration_date", nulls = Nulls.SKIP)
        public _FinalStage expirationDate(Optional<OffsetDateTime> expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @java.lang.Override
        public CreateCompanyOverrideRequestBody build() {
            return new CreateCompanyOverrideRequestBody(
                    companyId,
                    expirationDate,
                    featureId,
                    metricPeriod,
                    metricPeriodMonthReset,
                    valueBool,
                    valueNumeric,
                    valueTraitId,
                    valueType,
                    additionalProperties);
        }
    }
}
