/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingSubscriptionDiscountView.Builder.class)
public final class BillingSubscriptionDiscountView {
    private final Optional<Integer> amountOff;

    private final String couponId;

    private final String couponName;

    private final Optional<String> currency;

    private final Optional<String> customerFacingCode;

    private final String discountExternalId;

    private final String duration;

    private final Optional<Integer> durationInMonths;

    private final Optional<OffsetDateTime> endedAt;

    private final boolean isActive;

    private final Optional<Double> percentOff;

    private final Optional<String> promoCodeExternalId;

    private final OffsetDateTime startedAt;

    private final String subscriptionExternalId;

    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionDiscountView(
            Optional<Integer> amountOff,
            String couponId,
            String couponName,
            Optional<String> currency,
            Optional<String> customerFacingCode,
            String discountExternalId,
            String duration,
            Optional<Integer> durationInMonths,
            Optional<OffsetDateTime> endedAt,
            boolean isActive,
            Optional<Double> percentOff,
            Optional<String> promoCodeExternalId,
            OffsetDateTime startedAt,
            String subscriptionExternalId,
            Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.couponId = couponId;
        this.couponName = couponName;
        this.currency = currency;
        this.customerFacingCode = customerFacingCode;
        this.discountExternalId = discountExternalId;
        this.duration = duration;
        this.durationInMonths = durationInMonths;
        this.endedAt = endedAt;
        this.isActive = isActive;
        this.percentOff = percentOff;
        this.promoCodeExternalId = promoCodeExternalId;
        this.startedAt = startedAt;
        this.subscriptionExternalId = subscriptionExternalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount_off")
    public Optional<Integer> getAmountOff() {
        return amountOff;
    }

    @JsonProperty("coupon_id")
    public String getCouponId() {
        return couponId;
    }

    @JsonProperty("coupon_name")
    public String getCouponName() {
        return couponName;
    }

    @JsonProperty("currency")
    public Optional<String> getCurrency() {
        return currency;
    }

    @JsonProperty("customer_facing_code")
    public Optional<String> getCustomerFacingCode() {
        return customerFacingCode;
    }

    @JsonProperty("discount_external_id")
    public String getDiscountExternalId() {
        return discountExternalId;
    }

    @JsonProperty("duration")
    public String getDuration() {
        return duration;
    }

    @JsonProperty("duration_in_months")
    public Optional<Integer> getDurationInMonths() {
        return durationInMonths;
    }

    @JsonProperty("ended_at")
    public Optional<OffsetDateTime> getEndedAt() {
        return endedAt;
    }

    @JsonProperty("is_active")
    public boolean getIsActive() {
        return isActive;
    }

    @JsonProperty("percent_off")
    public Optional<Double> getPercentOff() {
        return percentOff;
    }

    @JsonProperty("promo_code_external_id")
    public Optional<String> getPromoCodeExternalId() {
        return promoCodeExternalId;
    }

    @JsonProperty("started_at")
    public OffsetDateTime getStartedAt() {
        return startedAt;
    }

    @JsonProperty("subscription_external_id")
    public String getSubscriptionExternalId() {
        return subscriptionExternalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingSubscriptionDiscountView && equalTo((BillingSubscriptionDiscountView) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionDiscountView other) {
        return amountOff.equals(other.amountOff)
                && couponId.equals(other.couponId)
                && couponName.equals(other.couponName)
                && currency.equals(other.currency)
                && customerFacingCode.equals(other.customerFacingCode)
                && discountExternalId.equals(other.discountExternalId)
                && duration.equals(other.duration)
                && durationInMonths.equals(other.durationInMonths)
                && endedAt.equals(other.endedAt)
                && isActive == other.isActive
                && percentOff.equals(other.percentOff)
                && promoCodeExternalId.equals(other.promoCodeExternalId)
                && startedAt.equals(other.startedAt)
                && subscriptionExternalId.equals(other.subscriptionExternalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.amountOff,
                this.couponId,
                this.couponName,
                this.currency,
                this.customerFacingCode,
                this.discountExternalId,
                this.duration,
                this.durationInMonths,
                this.endedAt,
                this.isActive,
                this.percentOff,
                this.promoCodeExternalId,
                this.startedAt,
                this.subscriptionExternalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CouponIdStage builder() {
        return new Builder();
    }

    public interface CouponIdStage {
        CouponNameStage couponId(@NotNull String couponId);

        Builder from(BillingSubscriptionDiscountView other);
    }

    public interface CouponNameStage {
        DiscountExternalIdStage couponName(@NotNull String couponName);
    }

    public interface DiscountExternalIdStage {
        DurationStage discountExternalId(@NotNull String discountExternalId);
    }

    public interface DurationStage {
        IsActiveStage duration(@NotNull String duration);
    }

    public interface IsActiveStage {
        StartedAtStage isActive(boolean isActive);
    }

    public interface StartedAtStage {
        SubscriptionExternalIdStage startedAt(@NotNull OffsetDateTime startedAt);
    }

    public interface SubscriptionExternalIdStage {
        _FinalStage subscriptionExternalId(@NotNull String subscriptionExternalId);
    }

    public interface _FinalStage {
        BillingSubscriptionDiscountView build();

        _FinalStage amountOff(Optional<Integer> amountOff);

        _FinalStage amountOff(Integer amountOff);

        _FinalStage currency(Optional<String> currency);

        _FinalStage currency(String currency);

        _FinalStage customerFacingCode(Optional<String> customerFacingCode);

        _FinalStage customerFacingCode(String customerFacingCode);

        _FinalStage durationInMonths(Optional<Integer> durationInMonths);

        _FinalStage durationInMonths(Integer durationInMonths);

        _FinalStage endedAt(Optional<OffsetDateTime> endedAt);

        _FinalStage endedAt(OffsetDateTime endedAt);

        _FinalStage percentOff(Optional<Double> percentOff);

        _FinalStage percentOff(Double percentOff);

        _FinalStage promoCodeExternalId(Optional<String> promoCodeExternalId);

        _FinalStage promoCodeExternalId(String promoCodeExternalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CouponIdStage,
                    CouponNameStage,
                    DiscountExternalIdStage,
                    DurationStage,
                    IsActiveStage,
                    StartedAtStage,
                    SubscriptionExternalIdStage,
                    _FinalStage {
        private String couponId;

        private String couponName;

        private String discountExternalId;

        private String duration;

        private boolean isActive;

        private OffsetDateTime startedAt;

        private String subscriptionExternalId;

        private Optional<String> promoCodeExternalId = Optional.empty();

        private Optional<Double> percentOff = Optional.empty();

        private Optional<OffsetDateTime> endedAt = Optional.empty();

        private Optional<Integer> durationInMonths = Optional.empty();

        private Optional<String> customerFacingCode = Optional.empty();

        private Optional<String> currency = Optional.empty();

        private Optional<Integer> amountOff = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingSubscriptionDiscountView other) {
            amountOff(other.getAmountOff());
            couponId(other.getCouponId());
            couponName(other.getCouponName());
            currency(other.getCurrency());
            customerFacingCode(other.getCustomerFacingCode());
            discountExternalId(other.getDiscountExternalId());
            duration(other.getDuration());
            durationInMonths(other.getDurationInMonths());
            endedAt(other.getEndedAt());
            isActive(other.getIsActive());
            percentOff(other.getPercentOff());
            promoCodeExternalId(other.getPromoCodeExternalId());
            startedAt(other.getStartedAt());
            subscriptionExternalId(other.getSubscriptionExternalId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("coupon_id")
        public CouponNameStage couponId(@NotNull String couponId) {
            this.couponId = Objects.requireNonNull(couponId, "couponId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("coupon_name")
        public DiscountExternalIdStage couponName(@NotNull String couponName) {
            this.couponName = Objects.requireNonNull(couponName, "couponName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("discount_external_id")
        public DurationStage discountExternalId(@NotNull String discountExternalId) {
            this.discountExternalId = Objects.requireNonNull(discountExternalId, "discountExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("duration")
        public IsActiveStage duration(@NotNull String duration) {
            this.duration = Objects.requireNonNull(duration, "duration must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_active")
        public StartedAtStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @java.lang.Override
        @JsonSetter("started_at")
        public SubscriptionExternalIdStage startedAt(@NotNull OffsetDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("subscription_external_id")
        public _FinalStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId =
                    Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage promoCodeExternalId(String promoCodeExternalId) {
            this.promoCodeExternalId = Optional.ofNullable(promoCodeExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "promo_code_external_id", nulls = Nulls.SKIP)
        public _FinalStage promoCodeExternalId(Optional<String> promoCodeExternalId) {
            this.promoCodeExternalId = promoCodeExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage percentOff(Double percentOff) {
            this.percentOff = Optional.ofNullable(percentOff);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "percent_off", nulls = Nulls.SKIP)
        public _FinalStage percentOff(Optional<Double> percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @java.lang.Override
        public _FinalStage endedAt(OffsetDateTime endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ended_at", nulls = Nulls.SKIP)
        public _FinalStage endedAt(Optional<OffsetDateTime> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage durationInMonths(Integer durationInMonths) {
            this.durationInMonths = Optional.ofNullable(durationInMonths);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "duration_in_months", nulls = Nulls.SKIP)
        public _FinalStage durationInMonths(Optional<Integer> durationInMonths) {
            this.durationInMonths = durationInMonths;
            return this;
        }

        @java.lang.Override
        public _FinalStage customerFacingCode(String customerFacingCode) {
            this.customerFacingCode = Optional.ofNullable(customerFacingCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "customer_facing_code", nulls = Nulls.SKIP)
        public _FinalStage customerFacingCode(Optional<String> customerFacingCode) {
            this.customerFacingCode = customerFacingCode;
            return this;
        }

        @java.lang.Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "currency", nulls = Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @java.lang.Override
        public _FinalStage amountOff(Integer amountOff) {
            this.amountOff = Optional.ofNullable(amountOff);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "amount_off", nulls = Nulls.SKIP)
        public _FinalStage amountOff(Optional<Integer> amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @java.lang.Override
        public BillingSubscriptionDiscountView build() {
            return new BillingSubscriptionDiscountView(
                    amountOff,
                    couponId,
                    couponName,
                    currency,
                    customerFacingCode,
                    discountExternalId,
                    duration,
                    durationInMonths,
                    endedAt,
                    isActive,
                    percentOff,
                    promoCodeExternalId,
                    startedAt,
                    subscriptionExternalId,
                    additionalProperties);
        }
    }
}
