/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateBillingPriceTierRequestBody.Builder.class)
public final class CreateBillingPriceTierRequestBody {
    private final Optional<Integer> flatAmount;

    private final Optional<Integer> perUnitPrice;

    private final String priceExternalId;

    private final Optional<Integer> upTo;

    private final Map<String, Object> additionalProperties;

    private CreateBillingPriceTierRequestBody(
            Optional<Integer> flatAmount,
            Optional<Integer> perUnitPrice,
            String priceExternalId,
            Optional<Integer> upTo,
            Map<String, Object> additionalProperties) {
        this.flatAmount = flatAmount;
        this.perUnitPrice = perUnitPrice;
        this.priceExternalId = priceExternalId;
        this.upTo = upTo;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("flat_amount")
    public Optional<Integer> getFlatAmount() {
        return flatAmount;
    }

    @JsonProperty("per_unit_price")
    public Optional<Integer> getPerUnitPrice() {
        return perUnitPrice;
    }

    @JsonProperty("price_external_id")
    public String getPriceExternalId() {
        return priceExternalId;
    }

    @JsonProperty("up_to")
    public Optional<Integer> getUpTo() {
        return upTo;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateBillingPriceTierRequestBody && equalTo((CreateBillingPriceTierRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingPriceTierRequestBody other) {
        return flatAmount.equals(other.flatAmount)
                && perUnitPrice.equals(other.perUnitPrice)
                && priceExternalId.equals(other.priceExternalId)
                && upTo.equals(other.upTo);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.flatAmount, this.perUnitPrice, this.priceExternalId, this.upTo);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PriceExternalIdStage builder() {
        return new Builder();
    }

    public interface PriceExternalIdStage {
        _FinalStage priceExternalId(@NotNull String priceExternalId);

        Builder from(CreateBillingPriceTierRequestBody other);
    }

    public interface _FinalStage {
        CreateBillingPriceTierRequestBody build();

        _FinalStage flatAmount(Optional<Integer> flatAmount);

        _FinalStage flatAmount(Integer flatAmount);

        _FinalStage perUnitPrice(Optional<Integer> perUnitPrice);

        _FinalStage perUnitPrice(Integer perUnitPrice);

        _FinalStage upTo(Optional<Integer> upTo);

        _FinalStage upTo(Integer upTo);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PriceExternalIdStage, _FinalStage {
        private String priceExternalId;

        private Optional<Integer> upTo = Optional.empty();

        private Optional<Integer> perUnitPrice = Optional.empty();

        private Optional<Integer> flatAmount = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateBillingPriceTierRequestBody other) {
            flatAmount(other.getFlatAmount());
            perUnitPrice(other.getPerUnitPrice());
            priceExternalId(other.getPriceExternalId());
            upTo(other.getUpTo());
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_external_id")
        public _FinalStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage upTo(Integer upTo) {
            this.upTo = Optional.ofNullable(upTo);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "up_to", nulls = Nulls.SKIP)
        public _FinalStage upTo(Optional<Integer> upTo) {
            this.upTo = upTo;
            return this;
        }

        @java.lang.Override
        public _FinalStage perUnitPrice(Integer perUnitPrice) {
            this.perUnitPrice = Optional.ofNullable(perUnitPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "per_unit_price", nulls = Nulls.SKIP)
        public _FinalStage perUnitPrice(Optional<Integer> perUnitPrice) {
            this.perUnitPrice = perUnitPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage flatAmount(Integer flatAmount) {
            this.flatAmount = Optional.ofNullable(flatAmount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "flat_amount", nulls = Nulls.SKIP)
        public _FinalStage flatAmount(Optional<Integer> flatAmount) {
            this.flatAmount = flatAmount;
            return this;
        }

        @java.lang.Override
        public CreateBillingPriceTierRequestBody build() {
            return new CreateBillingPriceTierRequestBody(
                    flatAmount, perUnitPrice, priceExternalId, upTo, additionalProperties);
        }
    }
}
