/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CrmLineItemResponseData.Builder.class)
public final class CrmLineItemResponseData {
    private final String accountId;

    private final OffsetDateTime createdAt;

    private final Optional<String> dealId;

    private final String environmentId;

    private final Optional<String> productExternalId;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private CrmLineItemResponseData(
            String accountId,
            OffsetDateTime createdAt,
            Optional<String> dealId,
            String environmentId,
            Optional<String> productExternalId,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.dealId = dealId;
        this.environmentId = environmentId;
        this.productExternalId = productExternalId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("deal_id")
    public Optional<String> getDealId() {
        return dealId;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("product_external_id")
    public Optional<String> getProductExternalId() {
        return productExternalId;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CrmLineItemResponseData && equalTo((CrmLineItemResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CrmLineItemResponseData other) {
        return accountId.equals(other.accountId)
                && createdAt.equals(other.createdAt)
                && dealId.equals(other.dealId)
                && environmentId.equals(other.environmentId)
                && productExternalId.equals(other.productExternalId)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.createdAt,
                this.dealId,
                this.environmentId,
                this.productExternalId,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        CreatedAtStage accountId(@NotNull String accountId);

        Builder from(CrmLineItemResponseData other);
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface EnvironmentIdStage {
        UpdatedAtStage environmentId(@NotNull String environmentId);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        CrmLineItemResponseData build();

        _FinalStage dealId(Optional<String> dealId);

        _FinalStage dealId(String dealId);

        _FinalStage productExternalId(Optional<String> productExternalId);

        _FinalStage productExternalId(String productExternalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage, CreatedAtStage, EnvironmentIdStage, UpdatedAtStage, _FinalStage {
        private String accountId;

        private OffsetDateTime createdAt;

        private String environmentId;

        private OffsetDateTime updatedAt;

        private Optional<String> productExternalId = Optional.empty();

        private Optional<String> dealId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CrmLineItemResponseData other) {
            accountId(other.getAccountId());
            createdAt(other.getCreatedAt());
            dealId(other.getDealId());
            environmentId(other.getEnvironmentId());
            productExternalId(other.getProductExternalId());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public UpdatedAtStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage productExternalId(String productExternalId) {
            this.productExternalId = Optional.ofNullable(productExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "product_external_id", nulls = Nulls.SKIP)
        public _FinalStage productExternalId(Optional<String> productExternalId) {
            this.productExternalId = productExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage dealId(String dealId) {
            this.dealId = Optional.ofNullable(dealId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "deal_id", nulls = Nulls.SKIP)
        public _FinalStage dealId(Optional<String> dealId) {
            this.dealId = dealId;
            return this;
        }

        @java.lang.Override
        public CrmLineItemResponseData build() {
            return new CrmLineItemResponseData(
                    accountId, createdAt, dealId, environmentId, productExternalId, updatedAt, additionalProperties);
        }
    }
}
