/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FlagDetailResponseData.Builder.class)
public final class FlagDetailResponseData {
    private final OffsetDateTime createdAt;

    private final boolean defaultValue;

    private final String description;

    private final Optional<FeatureResponseData> feature;

    private final Optional<String> featureId;

    private final String flagType;

    private final String id;

    private final String key;

    private final Optional<OffsetDateTime> lastCheckedAt;

    private final Optional<String> maintainerId;

    private final String name;

    private final List<RuleDetailResponseData> rules;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private FlagDetailResponseData(
            OffsetDateTime createdAt,
            boolean defaultValue,
            String description,
            Optional<FeatureResponseData> feature,
            Optional<String> featureId,
            String flagType,
            String id,
            String key,
            Optional<OffsetDateTime> lastCheckedAt,
            Optional<String> maintainerId,
            String name,
            List<RuleDetailResponseData> rules,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.defaultValue = defaultValue;
        this.description = description;
        this.feature = feature;
        this.featureId = featureId;
        this.flagType = flagType;
        this.id = id;
        this.key = key;
        this.lastCheckedAt = lastCheckedAt;
        this.maintainerId = maintainerId;
        this.name = name;
        this.rules = rules;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("default_value")
    public boolean getDefaultValue() {
        return defaultValue;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("feature")
    public Optional<FeatureResponseData> getFeature() {
        return feature;
    }

    @JsonProperty("feature_id")
    public Optional<String> getFeatureId() {
        return featureId;
    }

    @JsonProperty("flag_type")
    public String getFlagType() {
        return flagType;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("key")
    public String getKey() {
        return key;
    }

    @JsonProperty("last_checked_at")
    public Optional<OffsetDateTime> getLastCheckedAt() {
        return lastCheckedAt;
    }

    @JsonProperty("maintainer_id")
    public Optional<String> getMaintainerId() {
        return maintainerId;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("rules")
    public List<RuleDetailResponseData> getRules() {
        return rules;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FlagDetailResponseData && equalTo((FlagDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FlagDetailResponseData other) {
        return createdAt.equals(other.createdAt)
                && defaultValue == other.defaultValue
                && description.equals(other.description)
                && feature.equals(other.feature)
                && featureId.equals(other.featureId)
                && flagType.equals(other.flagType)
                && id.equals(other.id)
                && key.equals(other.key)
                && lastCheckedAt.equals(other.lastCheckedAt)
                && maintainerId.equals(other.maintainerId)
                && name.equals(other.name)
                && rules.equals(other.rules)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.defaultValue,
                this.description,
                this.feature,
                this.featureId,
                this.flagType,
                this.id,
                this.key,
                this.lastCheckedAt,
                this.maintainerId,
                this.name,
                this.rules,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        DefaultValueStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(FlagDetailResponseData other);
    }

    public interface DefaultValueStage {
        DescriptionStage defaultValue(boolean defaultValue);
    }

    public interface DescriptionStage {
        FlagTypeStage description(@NotNull String description);
    }

    public interface FlagTypeStage {
        IdStage flagType(@NotNull String flagType);
    }

    public interface IdStage {
        KeyStage id(@NotNull String id);
    }

    public interface KeyStage {
        NameStage key(@NotNull String key);
    }

    public interface NameStage {
        UpdatedAtStage name(@NotNull String name);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        FlagDetailResponseData build();

        _FinalStage feature(Optional<FeatureResponseData> feature);

        _FinalStage feature(FeatureResponseData feature);

        _FinalStage featureId(Optional<String> featureId);

        _FinalStage featureId(String featureId);

        _FinalStage lastCheckedAt(Optional<OffsetDateTime> lastCheckedAt);

        _FinalStage lastCheckedAt(OffsetDateTime lastCheckedAt);

        _FinalStage maintainerId(Optional<String> maintainerId);

        _FinalStage maintainerId(String maintainerId);

        _FinalStage rules(List<RuleDetailResponseData> rules);

        _FinalStage addRules(RuleDetailResponseData rules);

        _FinalStage addAllRules(List<RuleDetailResponseData> rules);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    DefaultValueStage,
                    DescriptionStage,
                    FlagTypeStage,
                    IdStage,
                    KeyStage,
                    NameStage,
                    UpdatedAtStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private boolean defaultValue;

        private String description;

        private String flagType;

        private String id;

        private String key;

        private String name;

        private OffsetDateTime updatedAt;

        private List<RuleDetailResponseData> rules = new ArrayList<>();

        private Optional<String> maintainerId = Optional.empty();

        private Optional<OffsetDateTime> lastCheckedAt = Optional.empty();

        private Optional<String> featureId = Optional.empty();

        private Optional<FeatureResponseData> feature = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FlagDetailResponseData other) {
            createdAt(other.getCreatedAt());
            defaultValue(other.getDefaultValue());
            description(other.getDescription());
            feature(other.getFeature());
            featureId(other.getFeatureId());
            flagType(other.getFlagType());
            id(other.getId());
            key(other.getKey());
            lastCheckedAt(other.getLastCheckedAt());
            maintainerId(other.getMaintainerId());
            name(other.getName());
            rules(other.getRules());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DefaultValueStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("default_value")
        public DescriptionStage defaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public FlagTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("flag_type")
        public IdStage flagType(@NotNull String flagType) {
            this.flagType = Objects.requireNonNull(flagType, "flagType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("key")
        public NameStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllRules(List<RuleDetailResponseData> rules) {
            this.rules.addAll(rules);
            return this;
        }

        @java.lang.Override
        public _FinalStage addRules(RuleDetailResponseData rules) {
            this.rules.add(rules);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rules", nulls = Nulls.SKIP)
        public _FinalStage rules(List<RuleDetailResponseData> rules) {
            this.rules.clear();
            this.rules.addAll(rules);
            return this;
        }

        @java.lang.Override
        public _FinalStage maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "maintainer_id", nulls = Nulls.SKIP)
        public _FinalStage maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastCheckedAt(OffsetDateTime lastCheckedAt) {
            this.lastCheckedAt = Optional.ofNullable(lastCheckedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_checked_at", nulls = Nulls.SKIP)
        public _FinalStage lastCheckedAt(Optional<OffsetDateTime> lastCheckedAt) {
            this.lastCheckedAt = lastCheckedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature_id", nulls = Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @java.lang.Override
        public _FinalStage feature(FeatureResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature", nulls = Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @java.lang.Override
        public FlagDetailResponseData build() {
            return new FlagDetailResponseData(
                    createdAt,
                    defaultValue,
                    description,
                    feature,
                    featureId,
                    flagType,
                    id,
                    key,
                    lastCheckedAt,
                    maintainerId,
                    name,
                    rules,
                    updatedAt,
                    additionalProperties);
        }
    }
}
