/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanEntitlementResponseData.Builder.class)
public final class PlanEntitlementResponseData {
    private final OffsetDateTime createdAt;

    private final String environmentId;

    private final Optional<FeatureResponseData> feature;

    private final String featureId;

    private final String id;

    private final Optional<BillingPriceView> meteredMonthlyPrice;

    private final Optional<BillingPriceView> meteredYearlyPrice;

    private final Optional<String> metricPeriod;

    private final Optional<String> metricPeriodMonthReset;

    private final Optional<PlanResponseData> plan;

    private final String planId;

    private final Optional<String> priceBehavior;

    private final String ruleId;

    private final Optional<String> ruleIdUsageExceeded;

    private final Optional<Integer> softLimit;

    private final OffsetDateTime updatedAt;

    private final Optional<Boolean> valueBool;

    private final Optional<Integer> valueNumeric;

    private final Optional<EntityTraitDefinitionResponseData> valueTrait;

    private final Optional<String> valueTraitId;

    private final String valueType;

    private final Map<String, Object> additionalProperties;

    private PlanEntitlementResponseData(
            OffsetDateTime createdAt,
            String environmentId,
            Optional<FeatureResponseData> feature,
            String featureId,
            String id,
            Optional<BillingPriceView> meteredMonthlyPrice,
            Optional<BillingPriceView> meteredYearlyPrice,
            Optional<String> metricPeriod,
            Optional<String> metricPeriodMonthReset,
            Optional<PlanResponseData> plan,
            String planId,
            Optional<String> priceBehavior,
            String ruleId,
            Optional<String> ruleIdUsageExceeded,
            Optional<Integer> softLimit,
            OffsetDateTime updatedAt,
            Optional<Boolean> valueBool,
            Optional<Integer> valueNumeric,
            Optional<EntityTraitDefinitionResponseData> valueTrait,
            Optional<String> valueTraitId,
            String valueType,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.feature = feature;
        this.featureId = featureId;
        this.id = id;
        this.meteredMonthlyPrice = meteredMonthlyPrice;
        this.meteredYearlyPrice = meteredYearlyPrice;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.plan = plan;
        this.planId = planId;
        this.priceBehavior = priceBehavior;
        this.ruleId = ruleId;
        this.ruleIdUsageExceeded = ruleIdUsageExceeded;
        this.softLimit = softLimit;
        this.updatedAt = updatedAt;
        this.valueBool = valueBool;
        this.valueNumeric = valueNumeric;
        this.valueTrait = valueTrait;
        this.valueTraitId = valueTraitId;
        this.valueType = valueType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("feature")
    public Optional<FeatureResponseData> getFeature() {
        return feature;
    }

    @JsonProperty("feature_id")
    public String getFeatureId() {
        return featureId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("metered_monthly_price")
    public Optional<BillingPriceView> getMeteredMonthlyPrice() {
        return meteredMonthlyPrice;
    }

    @JsonProperty("metered_yearly_price")
    public Optional<BillingPriceView> getMeteredYearlyPrice() {
        return meteredYearlyPrice;
    }

    @JsonProperty("metric_period")
    public Optional<String> getMetricPeriod() {
        return metricPeriod;
    }

    @JsonProperty("metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return metricPeriodMonthReset;
    }

    @JsonProperty("plan")
    public Optional<PlanResponseData> getPlan() {
        return plan;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("price_behavior")
    public Optional<String> getPriceBehavior() {
        return priceBehavior;
    }

    @JsonProperty("rule_id")
    public String getRuleId() {
        return ruleId;
    }

    @JsonProperty("rule_id_usage_exceeded")
    public Optional<String> getRuleIdUsageExceeded() {
        return ruleIdUsageExceeded;
    }

    @JsonProperty("soft_limit")
    public Optional<Integer> getSoftLimit() {
        return softLimit;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("value_bool")
    public Optional<Boolean> getValueBool() {
        return valueBool;
    }

    @JsonProperty("value_numeric")
    public Optional<Integer> getValueNumeric() {
        return valueNumeric;
    }

    @JsonProperty("value_trait")
    public Optional<EntityTraitDefinitionResponseData> getValueTrait() {
        return valueTrait;
    }

    @JsonProperty("value_trait_id")
    public Optional<String> getValueTraitId() {
        return valueTraitId;
    }

    @JsonProperty("value_type")
    public String getValueType() {
        return valueType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanEntitlementResponseData && equalTo((PlanEntitlementResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanEntitlementResponseData other) {
        return createdAt.equals(other.createdAt)
                && environmentId.equals(other.environmentId)
                && feature.equals(other.feature)
                && featureId.equals(other.featureId)
                && id.equals(other.id)
                && meteredMonthlyPrice.equals(other.meteredMonthlyPrice)
                && meteredYearlyPrice.equals(other.meteredYearlyPrice)
                && metricPeriod.equals(other.metricPeriod)
                && metricPeriodMonthReset.equals(other.metricPeriodMonthReset)
                && plan.equals(other.plan)
                && planId.equals(other.planId)
                && priceBehavior.equals(other.priceBehavior)
                && ruleId.equals(other.ruleId)
                && ruleIdUsageExceeded.equals(other.ruleIdUsageExceeded)
                && softLimit.equals(other.softLimit)
                && updatedAt.equals(other.updatedAt)
                && valueBool.equals(other.valueBool)
                && valueNumeric.equals(other.valueNumeric)
                && valueTrait.equals(other.valueTrait)
                && valueTraitId.equals(other.valueTraitId)
                && valueType.equals(other.valueType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.environmentId,
                this.feature,
                this.featureId,
                this.id,
                this.meteredMonthlyPrice,
                this.meteredYearlyPrice,
                this.metricPeriod,
                this.metricPeriodMonthReset,
                this.plan,
                this.planId,
                this.priceBehavior,
                this.ruleId,
                this.ruleIdUsageExceeded,
                this.softLimit,
                this.updatedAt,
                this.valueBool,
                this.valueNumeric,
                this.valueTrait,
                this.valueTraitId,
                this.valueType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(PlanEntitlementResponseData other);
    }

    public interface EnvironmentIdStage {
        FeatureIdStage environmentId(@NotNull String environmentId);
    }

    public interface FeatureIdStage {
        IdStage featureId(@NotNull String featureId);
    }

    public interface IdStage {
        PlanIdStage id(@NotNull String id);
    }

    public interface PlanIdStage {
        RuleIdStage planId(@NotNull String planId);
    }

    public interface RuleIdStage {
        UpdatedAtStage ruleId(@NotNull String ruleId);
    }

    public interface UpdatedAtStage {
        ValueTypeStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface ValueTypeStage {
        _FinalStage valueType(@NotNull String valueType);
    }

    public interface _FinalStage {
        PlanEntitlementResponseData build();

        _FinalStage feature(Optional<FeatureResponseData> feature);

        _FinalStage feature(FeatureResponseData feature);

        _FinalStage meteredMonthlyPrice(Optional<BillingPriceView> meteredMonthlyPrice);

        _FinalStage meteredMonthlyPrice(BillingPriceView meteredMonthlyPrice);

        _FinalStage meteredYearlyPrice(Optional<BillingPriceView> meteredYearlyPrice);

        _FinalStage meteredYearlyPrice(BillingPriceView meteredYearlyPrice);

        _FinalStage metricPeriod(Optional<String> metricPeriod);

        _FinalStage metricPeriod(String metricPeriod);

        _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset);

        _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset);

        _FinalStage plan(Optional<PlanResponseData> plan);

        _FinalStage plan(PlanResponseData plan);

        _FinalStage priceBehavior(Optional<String> priceBehavior);

        _FinalStage priceBehavior(String priceBehavior);

        _FinalStage ruleIdUsageExceeded(Optional<String> ruleIdUsageExceeded);

        _FinalStage ruleIdUsageExceeded(String ruleIdUsageExceeded);

        _FinalStage softLimit(Optional<Integer> softLimit);

        _FinalStage softLimit(Integer softLimit);

        _FinalStage valueBool(Optional<Boolean> valueBool);

        _FinalStage valueBool(Boolean valueBool);

        _FinalStage valueNumeric(Optional<Integer> valueNumeric);

        _FinalStage valueNumeric(Integer valueNumeric);

        _FinalStage valueTrait(Optional<EntityTraitDefinitionResponseData> valueTrait);

        _FinalStage valueTrait(EntityTraitDefinitionResponseData valueTrait);

        _FinalStage valueTraitId(Optional<String> valueTraitId);

        _FinalStage valueTraitId(String valueTraitId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    EnvironmentIdStage,
                    FeatureIdStage,
                    IdStage,
                    PlanIdStage,
                    RuleIdStage,
                    UpdatedAtStage,
                    ValueTypeStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String environmentId;

        private String featureId;

        private String id;

        private String planId;

        private String ruleId;

        private OffsetDateTime updatedAt;

        private String valueType;

        private Optional<String> valueTraitId = Optional.empty();

        private Optional<EntityTraitDefinitionResponseData> valueTrait = Optional.empty();

        private Optional<Integer> valueNumeric = Optional.empty();

        private Optional<Boolean> valueBool = Optional.empty();

        private Optional<Integer> softLimit = Optional.empty();

        private Optional<String> ruleIdUsageExceeded = Optional.empty();

        private Optional<String> priceBehavior = Optional.empty();

        private Optional<PlanResponseData> plan = Optional.empty();

        private Optional<String> metricPeriodMonthReset = Optional.empty();

        private Optional<String> metricPeriod = Optional.empty();

        private Optional<BillingPriceView> meteredYearlyPrice = Optional.empty();

        private Optional<BillingPriceView> meteredMonthlyPrice = Optional.empty();

        private Optional<FeatureResponseData> feature = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanEntitlementResponseData other) {
            createdAt(other.getCreatedAt());
            environmentId(other.getEnvironmentId());
            feature(other.getFeature());
            featureId(other.getFeatureId());
            id(other.getId());
            meteredMonthlyPrice(other.getMeteredMonthlyPrice());
            meteredYearlyPrice(other.getMeteredYearlyPrice());
            metricPeriod(other.getMetricPeriod());
            metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            plan(other.getPlan());
            planId(other.getPlanId());
            priceBehavior(other.getPriceBehavior());
            ruleId(other.getRuleId());
            ruleIdUsageExceeded(other.getRuleIdUsageExceeded());
            softLimit(other.getSoftLimit());
            updatedAt(other.getUpdatedAt());
            valueBool(other.getValueBool());
            valueNumeric(other.getValueNumeric());
            valueTrait(other.getValueTrait());
            valueTraitId(other.getValueTraitId());
            valueType(other.getValueType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public FeatureIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_id")
        public IdStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public RuleIdStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("rule_id")
        public UpdatedAtStage ruleId(@NotNull String ruleId) {
            this.ruleId = Objects.requireNonNull(ruleId, "ruleId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public ValueTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value_type")
        public _FinalStage valueType(@NotNull String valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage valueTraitId(String valueTraitId) {
            this.valueTraitId = Optional.ofNullable(valueTraitId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_trait_id", nulls = Nulls.SKIP)
        public _FinalStage valueTraitId(Optional<String> valueTraitId) {
            this.valueTraitId = valueTraitId;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueTrait(EntityTraitDefinitionResponseData valueTrait) {
            this.valueTrait = Optional.ofNullable(valueTrait);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_trait", nulls = Nulls.SKIP)
        public _FinalStage valueTrait(Optional<EntityTraitDefinitionResponseData> valueTrait) {
            this.valueTrait = valueTrait;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_numeric", nulls = Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_bool", nulls = Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @java.lang.Override
        public _FinalStage softLimit(Integer softLimit) {
            this.softLimit = Optional.ofNullable(softLimit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "soft_limit", nulls = Nulls.SKIP)
        public _FinalStage softLimit(Optional<Integer> softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        @java.lang.Override
        public _FinalStage ruleIdUsageExceeded(String ruleIdUsageExceeded) {
            this.ruleIdUsageExceeded = Optional.ofNullable(ruleIdUsageExceeded);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rule_id_usage_exceeded", nulls = Nulls.SKIP)
        public _FinalStage ruleIdUsageExceeded(Optional<String> ruleIdUsageExceeded) {
            this.ruleIdUsageExceeded = ruleIdUsageExceeded;
            return this;
        }

        @java.lang.Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_behavior", nulls = Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @java.lang.Override
        public _FinalStage plan(PlanResponseData plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan", nulls = Nulls.SKIP)
        public _FinalStage plan(Optional<PlanResponseData> plan) {
            this.plan = plan;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period_month_reset", nulls = Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period", nulls = Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @java.lang.Override
        public _FinalStage meteredYearlyPrice(BillingPriceView meteredYearlyPrice) {
            this.meteredYearlyPrice = Optional.ofNullable(meteredYearlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metered_yearly_price", nulls = Nulls.SKIP)
        public _FinalStage meteredYearlyPrice(Optional<BillingPriceView> meteredYearlyPrice) {
            this.meteredYearlyPrice = meteredYearlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage meteredMonthlyPrice(BillingPriceView meteredMonthlyPrice) {
            this.meteredMonthlyPrice = Optional.ofNullable(meteredMonthlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metered_monthly_price", nulls = Nulls.SKIP)
        public _FinalStage meteredMonthlyPrice(Optional<BillingPriceView> meteredMonthlyPrice) {
            this.meteredMonthlyPrice = meteredMonthlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage feature(FeatureResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature", nulls = Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @java.lang.Override
        public PlanEntitlementResponseData build() {
            return new PlanEntitlementResponseData(
                    createdAt,
                    environmentId,
                    feature,
                    featureId,
                    id,
                    meteredMonthlyPrice,
                    meteredYearlyPrice,
                    metricPeriod,
                    metricPeriodMonthReset,
                    plan,
                    planId,
                    priceBehavior,
                    ruleId,
                    ruleIdUsageExceeded,
                    softLimit,
                    updatedAt,
                    valueBool,
                    valueNumeric,
                    valueTrait,
                    valueTraitId,
                    valueType,
                    additionalProperties);
        }
    }
}
