/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanGroupResponseData.Builder.class)
public final class PlanGroupResponseData {
    private final List<String> addOnIds;

    private final Optional<String> defaultPlanId;

    private final String id;

    private final List<OrderedPlansInGroup> planIds;

    private final Optional<Integer> trialDays;

    private final Optional<Boolean> trialPaymentMethodRequired;

    private final Map<String, Object> additionalProperties;

    private PlanGroupResponseData(
            List<String> addOnIds,
            Optional<String> defaultPlanId,
            String id,
            List<OrderedPlansInGroup> planIds,
            Optional<Integer> trialDays,
            Optional<Boolean> trialPaymentMethodRequired,
            Map<String, Object> additionalProperties) {
        this.addOnIds = addOnIds;
        this.defaultPlanId = defaultPlanId;
        this.id = id;
        this.planIds = planIds;
        this.trialDays = trialDays;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("add_on_ids")
    public List<String> getAddOnIds() {
        return addOnIds;
    }

    @JsonProperty("default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return defaultPlanId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("plan_ids")
    public List<OrderedPlansInGroup> getPlanIds() {
        return planIds;
    }

    @JsonProperty("trial_days")
    public Optional<Integer> getTrialDays() {
        return trialDays;
    }

    @JsonProperty("trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return trialPaymentMethodRequired;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanGroupResponseData && equalTo((PlanGroupResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupResponseData other) {
        return addOnIds.equals(other.addOnIds)
                && defaultPlanId.equals(other.defaultPlanId)
                && id.equals(other.id)
                && planIds.equals(other.planIds)
                && trialDays.equals(other.trialDays)
                && trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.addOnIds,
                this.defaultPlanId,
                this.id,
                this.planIds,
                this.trialDays,
                this.trialPaymentMethodRequired);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);

        Builder from(PlanGroupResponseData other);
    }

    public interface _FinalStage {
        PlanGroupResponseData build();

        _FinalStage addOnIds(List<String> addOnIds);

        _FinalStage addAddOnIds(String addOnIds);

        _FinalStage addAllAddOnIds(List<String> addOnIds);

        _FinalStage defaultPlanId(Optional<String> defaultPlanId);

        _FinalStage defaultPlanId(String defaultPlanId);

        _FinalStage planIds(List<OrderedPlansInGroup> planIds);

        _FinalStage addPlanIds(OrderedPlansInGroup planIds);

        _FinalStage addAllPlanIds(List<OrderedPlansInGroup> planIds);

        _FinalStage trialDays(Optional<Integer> trialDays);

        _FinalStage trialDays(Integer trialDays);

        _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired);

        _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();

        private Optional<Integer> trialDays = Optional.empty();

        private List<OrderedPlansInGroup> planIds = new ArrayList<>();

        private Optional<String> defaultPlanId = Optional.empty();

        private List<String> addOnIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanGroupResponseData other) {
            addOnIds(other.getAddOnIds());
            defaultPlanId(other.getDefaultPlanId());
            id(other.getId());
            planIds(other.getPlanIds());
            trialDays(other.getTrialDays());
            trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_payment_method_required", nulls = Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_days", nulls = Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllPlanIds(List<OrderedPlansInGroup> planIds) {
            this.planIds.addAll(planIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage addPlanIds(OrderedPlansInGroup planIds) {
            this.planIds.add(planIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_ids", nulls = Nulls.SKIP)
        public _FinalStage planIds(List<OrderedPlansInGroup> planIds) {
            this.planIds.clear();
            this.planIds.addAll(planIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_plan_id", nulls = Nulls.SKIP)
        public _FinalStage defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAddOnIds(List<String> addOnIds) {
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "add_on_ids", nulls = Nulls.SKIP)
        public _FinalStage addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @java.lang.Override
        public PlanGroupResponseData build() {
            return new PlanGroupResponseData(
                    addOnIds, defaultPlanId, id, planIds, trialDays, trialPaymentMethodRequired, additionalProperties);
        }
    }
}
