/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PreviewSubscriptionChangeResponseData.Builder.class)
public final class PreviewSubscriptionChangeResponseData {
    private final int amountOff;

    private final int dueNow;

    private final int newCharges;

    private final double percentOff;

    private final OffsetDateTime periodStart;

    private final boolean promoCodeApplied;

    private final int proration;

    private final Optional<OffsetDateTime> trialEnd;

    private final Map<String, Object> additionalProperties;

    private PreviewSubscriptionChangeResponseData(
            int amountOff,
            int dueNow,
            int newCharges,
            double percentOff,
            OffsetDateTime periodStart,
            boolean promoCodeApplied,
            int proration,
            Optional<OffsetDateTime> trialEnd,
            Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.dueNow = dueNow;
        this.newCharges = newCharges;
        this.percentOff = percentOff;
        this.periodStart = periodStart;
        this.promoCodeApplied = promoCodeApplied;
        this.proration = proration;
        this.trialEnd = trialEnd;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount_off")
    public int getAmountOff() {
        return amountOff;
    }

    @JsonProperty("due_now")
    public int getDueNow() {
        return dueNow;
    }

    @JsonProperty("new_charges")
    public int getNewCharges() {
        return newCharges;
    }

    @JsonProperty("percent_off")
    public double getPercentOff() {
        return percentOff;
    }

    @JsonProperty("period_start")
    public OffsetDateTime getPeriodStart() {
        return periodStart;
    }

    @JsonProperty("promo_code_applied")
    public boolean getPromoCodeApplied() {
        return promoCodeApplied;
    }

    @JsonProperty("proration")
    public int getProration() {
        return proration;
    }

    @JsonProperty("trial_end")
    public Optional<OffsetDateTime> getTrialEnd() {
        return trialEnd;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PreviewSubscriptionChangeResponseData
                && equalTo((PreviewSubscriptionChangeResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewSubscriptionChangeResponseData other) {
        return amountOff == other.amountOff
                && dueNow == other.dueNow
                && newCharges == other.newCharges
                && percentOff == other.percentOff
                && periodStart.equals(other.periodStart)
                && promoCodeApplied == other.promoCodeApplied
                && proration == other.proration
                && trialEnd.equals(other.trialEnd);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.amountOff,
                this.dueNow,
                this.newCharges,
                this.percentOff,
                this.periodStart,
                this.promoCodeApplied,
                this.proration,
                this.trialEnd);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountOffStage builder() {
        return new Builder();
    }

    public interface AmountOffStage {
        DueNowStage amountOff(int amountOff);

        Builder from(PreviewSubscriptionChangeResponseData other);
    }

    public interface DueNowStage {
        NewChargesStage dueNow(int dueNow);
    }

    public interface NewChargesStage {
        PercentOffStage newCharges(int newCharges);
    }

    public interface PercentOffStage {
        PeriodStartStage percentOff(double percentOff);
    }

    public interface PeriodStartStage {
        PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime periodStart);
    }

    public interface PromoCodeAppliedStage {
        ProrationStage promoCodeApplied(boolean promoCodeApplied);
    }

    public interface ProrationStage {
        _FinalStage proration(int proration);
    }

    public interface _FinalStage {
        PreviewSubscriptionChangeResponseData build();

        _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd);

        _FinalStage trialEnd(OffsetDateTime trialEnd);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AmountOffStage,
                    DueNowStage,
                    NewChargesStage,
                    PercentOffStage,
                    PeriodStartStage,
                    PromoCodeAppliedStage,
                    ProrationStage,
                    _FinalStage {
        private int amountOff;

        private int dueNow;

        private int newCharges;

        private double percentOff;

        private OffsetDateTime periodStart;

        private boolean promoCodeApplied;

        private int proration;

        private Optional<OffsetDateTime> trialEnd = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PreviewSubscriptionChangeResponseData other) {
            amountOff(other.getAmountOff());
            dueNow(other.getDueNow());
            newCharges(other.getNewCharges());
            percentOff(other.getPercentOff());
            periodStart(other.getPeriodStart());
            promoCodeApplied(other.getPromoCodeApplied());
            proration(other.getProration());
            trialEnd(other.getTrialEnd());
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_off")
        public DueNowStage amountOff(int amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @java.lang.Override
        @JsonSetter("due_now")
        public NewChargesStage dueNow(int dueNow) {
            this.dueNow = dueNow;
            return this;
        }

        @java.lang.Override
        @JsonSetter("new_charges")
        public PercentOffStage newCharges(int newCharges) {
            this.newCharges = newCharges;
            return this;
        }

        @java.lang.Override
        @JsonSetter("percent_off")
        public PeriodStartStage percentOff(double percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @java.lang.Override
        @JsonSetter("period_start")
        public PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime periodStart) {
            this.periodStart = Objects.requireNonNull(periodStart, "periodStart must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("promo_code_applied")
        public ProrationStage promoCodeApplied(boolean promoCodeApplied) {
            this.promoCodeApplied = promoCodeApplied;
            return this;
        }

        @java.lang.Override
        @JsonSetter("proration")
        public _FinalStage proration(int proration) {
            this.proration = proration;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialEnd(OffsetDateTime trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_end", nulls = Nulls.SKIP)
        public _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @java.lang.Override
        public PreviewSubscriptionChangeResponseData build() {
            return new PreviewSubscriptionChangeResponseData(
                    amountOff,
                    dueNow,
                    newCharges,
                    percentOff,
                    periodStart,
                    promoCodeApplied,
                    proration,
                    trialEnd,
                    additionalProperties);
        }
    }
}
