/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UsageBasedEntitlementRequestBody.Builder.class)
public final class UsageBasedEntitlementRequestBody {
    private final Optional<String> monthlyMeteredPriceId;

    private final Optional<String> priceBehavior;

    private final Optional<Integer> softLimit;

    private final Optional<String> yearlyMeteredPriceId;

    private final Map<String, Object> additionalProperties;

    private UsageBasedEntitlementRequestBody(
            Optional<String> monthlyMeteredPriceId,
            Optional<String> priceBehavior,
            Optional<Integer> softLimit,
            Optional<String> yearlyMeteredPriceId,
            Map<String, Object> additionalProperties) {
        this.monthlyMeteredPriceId = monthlyMeteredPriceId;
        this.priceBehavior = priceBehavior;
        this.softLimit = softLimit;
        this.yearlyMeteredPriceId = yearlyMeteredPriceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("monthly_metered_price_id")
    public Optional<String> getMonthlyMeteredPriceId() {
        return monthlyMeteredPriceId;
    }

    @JsonProperty("price_behavior")
    public Optional<String> getPriceBehavior() {
        return priceBehavior;
    }

    @JsonProperty("soft_limit")
    public Optional<Integer> getSoftLimit() {
        return softLimit;
    }

    @JsonProperty("yearly_metered_price_id")
    public Optional<String> getYearlyMeteredPriceId() {
        return yearlyMeteredPriceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UsageBasedEntitlementRequestBody && equalTo((UsageBasedEntitlementRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UsageBasedEntitlementRequestBody other) {
        return monthlyMeteredPriceId.equals(other.monthlyMeteredPriceId)
                && priceBehavior.equals(other.priceBehavior)
                && softLimit.equals(other.softLimit)
                && yearlyMeteredPriceId.equals(other.yearlyMeteredPriceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.monthlyMeteredPriceId, this.priceBehavior, this.softLimit, this.yearlyMeteredPriceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> monthlyMeteredPriceId = Optional.empty();

        private Optional<String> priceBehavior = Optional.empty();

        private Optional<Integer> softLimit = Optional.empty();

        private Optional<String> yearlyMeteredPriceId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(UsageBasedEntitlementRequestBody other) {
            monthlyMeteredPriceId(other.getMonthlyMeteredPriceId());
            priceBehavior(other.getPriceBehavior());
            softLimit(other.getSoftLimit());
            yearlyMeteredPriceId(other.getYearlyMeteredPriceId());
            return this;
        }

        @JsonSetter(value = "monthly_metered_price_id", nulls = Nulls.SKIP)
        public Builder monthlyMeteredPriceId(Optional<String> monthlyMeteredPriceId) {
            this.monthlyMeteredPriceId = monthlyMeteredPriceId;
            return this;
        }

        public Builder monthlyMeteredPriceId(String monthlyMeteredPriceId) {
            this.monthlyMeteredPriceId = Optional.ofNullable(monthlyMeteredPriceId);
            return this;
        }

        @JsonSetter(value = "price_behavior", nulls = Nulls.SKIP)
        public Builder priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        public Builder priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @JsonSetter(value = "soft_limit", nulls = Nulls.SKIP)
        public Builder softLimit(Optional<Integer> softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public Builder softLimit(Integer softLimit) {
            this.softLimit = Optional.ofNullable(softLimit);
            return this;
        }

        @JsonSetter(value = "yearly_metered_price_id", nulls = Nulls.SKIP)
        public Builder yearlyMeteredPriceId(Optional<String> yearlyMeteredPriceId) {
            this.yearlyMeteredPriceId = yearlyMeteredPriceId;
            return this;
        }

        public Builder yearlyMeteredPriceId(String yearlyMeteredPriceId) {
            this.yearlyMeteredPriceId = Optional.ofNullable(yearlyMeteredPriceId);
            return this;
        }

        public UsageBasedEntitlementRequestBody build() {
            return new UsageBasedEntitlementRequestBody(
                    monthlyMeteredPriceId, priceBehavior, softLimit, yearlyMeteredPriceId, additionalProperties);
        }
    }
}
