/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = WebhookResponseData.Builder.class)
public final class WebhookResponseData {
    private final OffsetDateTime createdAt;

    private final String id;

    private final String name;

    private final List<String> requestTypes;

    private final String secret;

    private final String status;

    private final OffsetDateTime updatedAt;

    private final String url;

    private final Map<String, Object> additionalProperties;

    private WebhookResponseData(
            OffsetDateTime createdAt,
            String id,
            String name,
            List<String> requestTypes,
            String secret,
            String status,
            OffsetDateTime updatedAt,
            String url,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.id = id;
        this.name = name;
        this.requestTypes = requestTypes;
        this.secret = secret;
        this.status = status;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("request_types")
    public List<String> getRequestTypes() {
        return requestTypes;
    }

    @JsonProperty("secret")
    public String getSecret() {
        return secret;
    }

    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof WebhookResponseData && equalTo((WebhookResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WebhookResponseData other) {
        return createdAt.equals(other.createdAt)
                && id.equals(other.id)
                && name.equals(other.name)
                && requestTypes.equals(other.requestTypes)
                && secret.equals(other.secret)
                && status.equals(other.status)
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.id,
                this.name,
                this.requestTypes,
                this.secret,
                this.status,
                this.updatedAt,
                this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        IdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(WebhookResponseData other);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        SecretStage name(@NotNull String name);
    }

    public interface SecretStage {
        StatusStage secret(@NotNull String secret);
    }

    public interface StatusStage {
        UpdatedAtStage status(@NotNull String status);
    }

    public interface UpdatedAtStage {
        UrlStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface UrlStage {
        _FinalStage url(@NotNull String url);
    }

    public interface _FinalStage {
        WebhookResponseData build();

        _FinalStage requestTypes(List<String> requestTypes);

        _FinalStage addRequestTypes(String requestTypes);

        _FinalStage addAllRequestTypes(List<String> requestTypes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    IdStage,
                    NameStage,
                    SecretStage,
                    StatusStage,
                    UpdatedAtStage,
                    UrlStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String id;

        private String name;

        private String secret;

        private String status;

        private OffsetDateTime updatedAt;

        private String url;

        private List<String> requestTypes = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(WebhookResponseData other) {
            createdAt(other.getCreatedAt());
            id(other.getId());
            name(other.getName());
            requestTypes(other.getRequestTypes());
            secret(other.getSecret());
            status(other.getStatus());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public SecretStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("secret")
        public StatusStage secret(@NotNull String secret) {
            this.secret = Objects.requireNonNull(secret, "secret must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public UrlStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllRequestTypes(List<String> requestTypes) {
            this.requestTypes.addAll(requestTypes);
            return this;
        }

        @java.lang.Override
        public _FinalStage addRequestTypes(String requestTypes) {
            this.requestTypes.add(requestTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "request_types", nulls = Nulls.SKIP)
        public _FinalStage requestTypes(List<String> requestTypes) {
            this.requestTypes.clear();
            this.requestTypes.addAll(requestTypes);
            return this;
        }

        @java.lang.Override
        public WebhookResponseData build() {
            return new WebhookResponseData(
                    createdAt, id, name, requestTypes, secret, status, updatedAt, url, additionalProperties);
        }
    }
}
