/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api;

import com.schematic.api.BaseSchematic;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.Environment;
import okhttp3.OkHttpClient;

public final class BaseSchematicBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private Environment environment = Environment.DEFAULT;

    public BaseSchematicBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public BaseSchematicBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public BaseSchematicBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public BaseSchematicBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public BaseSchematicBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public BaseSchematic build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("X-Schematic-Api-Key", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment);
        return new BaseSchematic(this.clientOptionsBuilder.build());
    }
}

