/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.core;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Timeout;

public class NoOpHttpClient
extends OkHttpClient {
    private static final Response EMPTY_RESPONSE = new Response.Builder().request(new Request.Builder().url("https://example.com").build()).protocol(Protocol.HTTP_1_1).code(200).message("OK").body(ResponseBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"{}")).build();

    public NoOpHttpClient() {
        super(new OkHttpClient.Builder().callTimeout(1L, TimeUnit.MILLISECONDS).connectTimeout(1L, TimeUnit.MILLISECONDS).readTimeout(1L, TimeUnit.MILLISECONDS).writeTimeout(1L, TimeUnit.MILLISECONDS).addInterceptor(chain -> EMPTY_RESPONSE));
    }

    public Call newCall(Request request) {
        return new NoOpCall(request);
    }

    private static class NoOpCall
    implements Call {
        private final Request request;
        private boolean executed = false;
        private boolean canceled = false;

        public NoOpCall(Request request) {
            this.request = request;
        }

        public Request request() {
            return this.request;
        }

        public Response execute() throws IOException {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            this.executed = true;
            return EMPTY_RESPONSE;
        }

        public void enqueue(Callback callback) {
            if (this.executed) {
                callback.onFailure((Call)this, new IOException("Already Executed"));
                return;
            }
            if (this.canceled) {
                callback.onFailure((Call)this, new IOException("Canceled"));
                return;
            }
            this.executed = true;
            try {
                callback.onResponse((Call)this, EMPTY_RESPONSE);
            }
            catch (IOException e) {
                callback.onFailure((Call)this, e);
            }
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public Timeout timeout() {
            return Timeout.NONE;
        }

        public Call clone() {
            return new NoOpCall(this.request);
        }
    }
}

