/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.accesstokens.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class IssueTemporaryAccessTokenRequestBody {
    private final Map<String, String> lookup;
    private final String resourceType;
    private final Map<String, Object> additionalProperties;

    private IssueTemporaryAccessTokenRequestBody(Map<String, String> lookup, String resourceType, Map<String, Object> additionalProperties) {
        this.lookup = lookup;
        this.resourceType = resourceType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="lookup")
    public Map<String, String> getLookup() {
        return this.lookup;
    }

    @JsonProperty(value="resource_type")
    public String getResourceType() {
        return this.resourceType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IssueTemporaryAccessTokenRequestBody && this.equalTo((IssueTemporaryAccessTokenRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IssueTemporaryAccessTokenRequestBody other) {
        return this.lookup.equals(other.lookup) && this.resourceType.equals(other.resourceType);
    }

    public int hashCode() {
        return Objects.hash(this.lookup, this.resourceType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResourceTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ResourceTypeStage,
    _FinalStage {
        private String resourceType;
        private Map<String, String> lookup = new LinkedHashMap<String, String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(IssueTemporaryAccessTokenRequestBody other) {
            this.lookup(other.getLookup());
            this.resourceType(other.getResourceType());
            return this;
        }

        @Override
        @JsonSetter(value="resource_type")
        public _FinalStage resourceType(@NotNull String resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
            return this;
        }

        @Override
        public _FinalStage lookup(String key, String value) {
            this.lookup.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllLookup(Map<String, String> lookup) {
            this.lookup.putAll(lookup);
            return this;
        }

        @Override
        @JsonSetter(value="lookup", nulls=Nulls.SKIP)
        public _FinalStage lookup(Map<String, String> lookup) {
            this.lookup.clear();
            this.lookup.putAll(lookup);
            return this;
        }

        @Override
        public IssueTemporaryAccessTokenRequestBody build() {
            return new IssueTemporaryAccessTokenRequestBody(this.lookup, this.resourceType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public IssueTemporaryAccessTokenRequestBody build();

        public _FinalStage lookup(Map<String, String> var1);

        public _FinalStage putAllLookup(Map<String, String> var1);

        public _FinalStage lookup(String var1, String var2);
    }

    public static interface ResourceTypeStage {
        public _FinalStage resourceType(@NotNull String var1);

        public Builder from(IssueTemporaryAccessTokenRequestBody var1);
    }
}

