/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.CreateBillingPriceRequestBodyTierMode;
import com.schematic.api.resources.billing.types.CreateBillingPriceRequestBodyUsageType;
import com.schematic.api.types.CreateBillingPriceTierRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingPriceRequestBody {
    private final String currency;
    private final String externalAccountId;
    private final String interval;
    private final boolean isActive;
    private final Optional<String> meterId;
    private final int price;
    private final String priceExternalId;
    private final List<CreateBillingPriceTierRequestBody> priceTiers;
    private final String productExternalId;
    private final Optional<CreateBillingPriceRequestBodyTierMode> tierMode;
    private final CreateBillingPriceRequestBodyUsageType usageType;
    private final Map<String, Object> additionalProperties;

    private CreateBillingPriceRequestBody(String currency, String externalAccountId, String interval, boolean isActive, Optional<String> meterId, int price, String priceExternalId, List<CreateBillingPriceTierRequestBody> priceTiers, String productExternalId, Optional<CreateBillingPriceRequestBodyTierMode> tierMode, CreateBillingPriceRequestBodyUsageType usageType, Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.externalAccountId = externalAccountId;
        this.interval = interval;
        this.isActive = isActive;
        this.meterId = meterId;
        this.price = price;
        this.priceExternalId = priceExternalId;
        this.priceTiers = priceTiers;
        this.productExternalId = productExternalId;
        this.tierMode = tierMode;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="external_account_id")
    public String getExternalAccountId() {
        return this.externalAccountId;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="meter_id")
    public Optional<String> getMeterId() {
        return this.meterId;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="price_tiers")
    public List<CreateBillingPriceTierRequestBody> getPriceTiers() {
        return this.priceTiers;
    }

    @JsonProperty(value="product_external_id")
    public String getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="tier_mode")
    public Optional<CreateBillingPriceRequestBodyTierMode> getTierMode() {
        return this.tierMode;
    }

    @JsonProperty(value="usage_type")
    public CreateBillingPriceRequestBodyUsageType getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingPriceRequestBody && this.equalTo((CreateBillingPriceRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingPriceRequestBody other) {
        return this.currency.equals(other.currency) && this.externalAccountId.equals(other.externalAccountId) && this.interval.equals(other.interval) && this.isActive == other.isActive && this.meterId.equals(other.meterId) && this.price == other.price && this.priceExternalId.equals(other.priceExternalId) && this.priceTiers.equals(other.priceTiers) && this.productExternalId.equals(other.productExternalId) && this.tierMode.equals(other.tierMode) && this.usageType.equals((Object)other.usageType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currency, this.externalAccountId, this.interval, this.isActive, this.meterId, this.price, this.priceExternalId, this.priceTiers, this.productExternalId, this.tierMode, this.usageType});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CurrencyStage,
    ExternalAccountIdStage,
    IntervalStage,
    IsActiveStage,
    PriceStage,
    PriceExternalIdStage,
    ProductExternalIdStage,
    UsageTypeStage,
    _FinalStage {
        private String currency;
        private String externalAccountId;
        private String interval;
        private boolean isActive;
        private int price;
        private String priceExternalId;
        private String productExternalId;
        private CreateBillingPriceRequestBodyUsageType usageType;
        private Optional<CreateBillingPriceRequestBodyTierMode> tierMode = Optional.empty();
        private List<CreateBillingPriceTierRequestBody> priceTiers = new ArrayList<CreateBillingPriceTierRequestBody>();
        private Optional<String> meterId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingPriceRequestBody other) {
            this.currency(other.getCurrency());
            this.externalAccountId(other.getExternalAccountId());
            this.interval(other.getInterval());
            this.isActive(other.getIsActive());
            this.meterId(other.getMeterId());
            this.price(other.getPrice());
            this.priceExternalId(other.getPriceExternalId());
            this.priceTiers(other.getPriceTiers());
            this.productExternalId(other.getProductExternalId());
            this.tierMode(other.getTierMode());
            this.usageType(other.getUsageType());
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public ExternalAccountIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_account_id")
        public IntervalStage externalAccountId(@NotNull String externalAccountId) {
            this.externalAccountId = Objects.requireNonNull(externalAccountId, "externalAccountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public IsActiveStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public PriceStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public ProductExternalIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id")
        public UsageTypeStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="usage_type")
        public _FinalStage usageType(@NotNull CreateBillingPriceRequestBodyUsageType usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @Override
        public _FinalStage tierMode(CreateBillingPriceRequestBodyTierMode tierMode) {
            this.tierMode = Optional.ofNullable(tierMode);
            return this;
        }

        @Override
        @JsonSetter(value="tier_mode", nulls=Nulls.SKIP)
        public _FinalStage tierMode(Optional<CreateBillingPriceRequestBodyTierMode> tierMode) {
            this.tierMode = tierMode;
            return this;
        }

        @Override
        public _FinalStage addAllPriceTiers(List<CreateBillingPriceTierRequestBody> priceTiers) {
            this.priceTiers.addAll(priceTiers);
            return this;
        }

        @Override
        public _FinalStage addPriceTiers(CreateBillingPriceTierRequestBody priceTiers) {
            this.priceTiers.add(priceTiers);
            return this;
        }

        @Override
        @JsonSetter(value="price_tiers", nulls=Nulls.SKIP)
        public _FinalStage priceTiers(List<CreateBillingPriceTierRequestBody> priceTiers) {
            this.priceTiers.clear();
            this.priceTiers.addAll(priceTiers);
            return this;
        }

        @Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @Override
        @JsonSetter(value="meter_id", nulls=Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @Override
        public CreateBillingPriceRequestBody build() {
            return new CreateBillingPriceRequestBody(this.currency, this.externalAccountId, this.interval, this.isActive, this.meterId, this.price, this.priceExternalId, this.priceTiers, this.productExternalId, this.tierMode, this.usageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingPriceRequestBody build();

        public _FinalStage meterId(Optional<String> var1);

        public _FinalStage meterId(String var1);

        public _FinalStage priceTiers(List<CreateBillingPriceTierRequestBody> var1);

        public _FinalStage addPriceTiers(CreateBillingPriceTierRequestBody var1);

        public _FinalStage addAllPriceTiers(List<CreateBillingPriceTierRequestBody> var1);

        public _FinalStage tierMode(Optional<CreateBillingPriceRequestBodyTierMode> var1);

        public _FinalStage tierMode(CreateBillingPriceRequestBodyTierMode var1);
    }

    public static interface UsageTypeStage {
        public _FinalStage usageType(@NotNull CreateBillingPriceRequestBodyUsageType var1);
    }

    public static interface ProductExternalIdStage {
        public UsageTypeStage productExternalId(@NotNull String var1);
    }

    public static interface PriceExternalIdStage {
        public ProductExternalIdStage priceExternalId(@NotNull String var1);
    }

    public static interface PriceStage {
        public PriceExternalIdStage price(int var1);
    }

    public static interface IsActiveStage {
        public PriceStage isActive(boolean var1);
    }

    public static interface IntervalStage {
        public IsActiveStage interval(@NotNull String var1);
    }

    public static interface ExternalAccountIdStage {
        public IntervalStage externalAccountId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public ExternalAccountIdStage currency(@NotNull String var1);

        public Builder from(CreateBillingPriceRequestBody var1);
    }
}

