/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.CreateBillingSubscriptionsRequestBodyTrialEndSetting;
import com.schematic.api.types.BillingProductPricing;
import com.schematic.api.types.BillingSubscriptionDiscount;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingSubscriptionsRequestBody {
    private final Optional<Integer> cancelAt;
    private final boolean cancelAtPeriodEnd;
    private final String currency;
    private final String customerExternalId;
    private final Optional<String> defaultPaymentMethodId;
    private final List<BillingSubscriptionDiscount> discounts;
    private final OffsetDateTime expiredAt;
    private final Optional<String> interval;
    private final Optional<Map<String, JsonNode>> metadata;
    private final Optional<Integer> periodEnd;
    private final Optional<Integer> periodStart;
    private final List<BillingProductPricing> productExternalIds;
    private final Optional<String> status;
    private final String subscriptionExternalId;
    private final int totalPrice;
    private final Optional<Integer> trialEnd;
    private final Optional<CreateBillingSubscriptionsRequestBodyTrialEndSetting> trialEndSetting;
    private final Map<String, Object> additionalProperties;

    private CreateBillingSubscriptionsRequestBody(Optional<Integer> cancelAt, boolean cancelAtPeriodEnd, String currency, String customerExternalId, Optional<String> defaultPaymentMethodId, List<BillingSubscriptionDiscount> discounts, OffsetDateTime expiredAt, Optional<String> interval, Optional<Map<String, JsonNode>> metadata, Optional<Integer> periodEnd, Optional<Integer> periodStart, List<BillingProductPricing> productExternalIds, Optional<String> status, String subscriptionExternalId, int totalPrice, Optional<Integer> trialEnd, Optional<CreateBillingSubscriptionsRequestBodyTrialEndSetting> trialEndSetting, Map<String, Object> additionalProperties) {
        this.cancelAt = cancelAt;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        this.discounts = discounts;
        this.expiredAt = expiredAt;
        this.interval = interval;
        this.metadata = metadata;
        this.periodEnd = periodEnd;
        this.periodStart = periodStart;
        this.productExternalIds = productExternalIds;
        this.status = status;
        this.subscriptionExternalId = subscriptionExternalId;
        this.totalPrice = totalPrice;
        this.trialEnd = trialEnd;
        this.trialEndSetting = trialEndSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cancel_at")
    public Optional<Integer> getCancelAt() {
        return this.cancelAt;
    }

    @JsonProperty(value="cancel_at_period_end")
    public boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="default_payment_method_id")
    public Optional<String> getDefaultPaymentMethodId() {
        return this.defaultPaymentMethodId;
    }

    @JsonProperty(value="discounts")
    public List<BillingSubscriptionDiscount> getDiscounts() {
        return this.discounts;
    }

    @JsonProperty(value="expired_at")
    public OffsetDateTime getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @JsonProperty(value="metadata")
    public Optional<Map<String, JsonNode>> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="period_end")
    public Optional<Integer> getPeriodEnd() {
        return this.periodEnd;
    }

    @JsonProperty(value="period_start")
    public Optional<Integer> getPeriodStart() {
        return this.periodStart;
    }

    @JsonProperty(value="product_external_ids")
    public List<BillingProductPricing> getProductExternalIds() {
        return this.productExternalIds;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    @JsonProperty(value="subscription_external_id")
    public String getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    @JsonProperty(value="total_price")
    public int getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="trial_end")
    public Optional<Integer> getTrialEnd() {
        return this.trialEnd;
    }

    @JsonProperty(value="trial_end_setting")
    public Optional<CreateBillingSubscriptionsRequestBodyTrialEndSetting> getTrialEndSetting() {
        return this.trialEndSetting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingSubscriptionsRequestBody && this.equalTo((CreateBillingSubscriptionsRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingSubscriptionsRequestBody other) {
        return this.cancelAt.equals(other.cancelAt) && this.cancelAtPeriodEnd == other.cancelAtPeriodEnd && this.currency.equals(other.currency) && this.customerExternalId.equals(other.customerExternalId) && this.defaultPaymentMethodId.equals(other.defaultPaymentMethodId) && this.discounts.equals(other.discounts) && this.expiredAt.equals(other.expiredAt) && this.interval.equals(other.interval) && this.metadata.equals(other.metadata) && this.periodEnd.equals(other.periodEnd) && this.periodStart.equals(other.periodStart) && this.productExternalIds.equals(other.productExternalIds) && this.status.equals(other.status) && this.subscriptionExternalId.equals(other.subscriptionExternalId) && this.totalPrice == other.totalPrice && this.trialEnd.equals(other.trialEnd) && this.trialEndSetting.equals(other.trialEndSetting);
    }

    public int hashCode() {
        return Objects.hash(this.cancelAt, this.cancelAtPeriodEnd, this.currency, this.customerExternalId, this.defaultPaymentMethodId, this.discounts, this.expiredAt, this.interval, this.metadata, this.periodEnd, this.periodStart, this.productExternalIds, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.trialEndSetting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CancelAtPeriodEndStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CancelAtPeriodEndStage,
    CurrencyStage,
    CustomerExternalIdStage,
    ExpiredAtStage,
    SubscriptionExternalIdStage,
    TotalPriceStage,
    _FinalStage {
        private boolean cancelAtPeriodEnd;
        private String currency;
        private String customerExternalId;
        private OffsetDateTime expiredAt;
        private String subscriptionExternalId;
        private int totalPrice;
        private Optional<CreateBillingSubscriptionsRequestBodyTrialEndSetting> trialEndSetting = Optional.empty();
        private Optional<Integer> trialEnd = Optional.empty();
        private Optional<String> status = Optional.empty();
        private List<BillingProductPricing> productExternalIds = new ArrayList<BillingProductPricing>();
        private Optional<Integer> periodStart = Optional.empty();
        private Optional<Integer> periodEnd = Optional.empty();
        private Optional<Map<String, JsonNode>> metadata = Optional.empty();
        private Optional<String> interval = Optional.empty();
        private List<BillingSubscriptionDiscount> discounts = new ArrayList<BillingSubscriptionDiscount>();
        private Optional<String> defaultPaymentMethodId = Optional.empty();
        private Optional<Integer> cancelAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingSubscriptionsRequestBody other) {
            this.cancelAt(other.getCancelAt());
            this.cancelAtPeriodEnd(other.getCancelAtPeriodEnd());
            this.currency(other.getCurrency());
            this.customerExternalId(other.getCustomerExternalId());
            this.defaultPaymentMethodId(other.getDefaultPaymentMethodId());
            this.discounts(other.getDiscounts());
            this.expiredAt(other.getExpiredAt());
            this.interval(other.getInterval());
            this.metadata(other.getMetadata());
            this.periodEnd(other.getPeriodEnd());
            this.periodStart(other.getPeriodStart());
            this.productExternalIds(other.getProductExternalIds());
            this.status(other.getStatus());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            this.totalPrice(other.getTotalPrice());
            this.trialEnd(other.getTrialEnd());
            this.trialEndSetting(other.getTrialEndSetting());
            return this;
        }

        @Override
        @JsonSetter(value="cancel_at_period_end")
        public CurrencyStage cancelAtPeriodEnd(boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public ExpiredAtStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expired_at")
        public SubscriptionExternalIdStage expiredAt(@NotNull OffsetDateTime expiredAt) {
            this.expiredAt = Objects.requireNonNull(expiredAt, "expiredAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id")
        public TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId = Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage trialEndSetting(CreateBillingSubscriptionsRequestBodyTrialEndSetting trialEndSetting) {
            this.trialEndSetting = Optional.ofNullable(trialEndSetting);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end_setting", nulls=Nulls.SKIP)
        public _FinalStage trialEndSetting(Optional<CreateBillingSubscriptionsRequestBodyTrialEndSetting> trialEndSetting) {
            this.trialEndSetting = trialEndSetting;
            return this;
        }

        @Override
        public _FinalStage trialEnd(Integer trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end", nulls=Nulls.SKIP)
        public _FinalStage trialEnd(Optional<Integer> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @Override
        public _FinalStage status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<String> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage addAllProductExternalIds(List<BillingProductPricing> productExternalIds) {
            this.productExternalIds.addAll(productExternalIds);
            return this;
        }

        @Override
        public _FinalStage addProductExternalIds(BillingProductPricing productExternalIds) {
            this.productExternalIds.add(productExternalIds);
            return this;
        }

        @Override
        @JsonSetter(value="product_external_ids", nulls=Nulls.SKIP)
        public _FinalStage productExternalIds(List<BillingProductPricing> productExternalIds) {
            this.productExternalIds.clear();
            this.productExternalIds.addAll(productExternalIds);
            return this;
        }

        @Override
        public _FinalStage periodStart(Integer periodStart) {
            this.periodStart = Optional.ofNullable(periodStart);
            return this;
        }

        @Override
        @JsonSetter(value="period_start", nulls=Nulls.SKIP)
        public _FinalStage periodStart(Optional<Integer> periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        @Override
        public _FinalStage periodEnd(Integer periodEnd) {
            this.periodEnd = Optional.ofNullable(periodEnd);
            return this;
        }

        @Override
        @JsonSetter(value="period_end", nulls=Nulls.SKIP)
        public _FinalStage periodEnd(Optional<Integer> periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, JsonNode> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, JsonNode>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        @Override
        @JsonSetter(value="interval", nulls=Nulls.SKIP)
        public _FinalStage interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscount> discounts) {
            this.discounts.addAll(discounts);
            return this;
        }

        @Override
        public _FinalStage addDiscounts(BillingSubscriptionDiscount discounts) {
            this.discounts.add(discounts);
            return this;
        }

        @Override
        @JsonSetter(value="discounts", nulls=Nulls.SKIP)
        public _FinalStage discounts(List<BillingSubscriptionDiscount> discounts) {
            this.discounts.clear();
            this.discounts.addAll(discounts);
            return this;
        }

        @Override
        public _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId) {
            this.defaultPaymentMethodId = Optional.ofNullable(defaultPaymentMethodId);
            return this;
        }

        @Override
        @JsonSetter(value="default_payment_method_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId) {
            this.defaultPaymentMethodId = defaultPaymentMethodId;
            return this;
        }

        @Override
        public _FinalStage cancelAt(Integer cancelAt) {
            this.cancelAt = Optional.ofNullable(cancelAt);
            return this;
        }

        @Override
        @JsonSetter(value="cancel_at", nulls=Nulls.SKIP)
        public _FinalStage cancelAt(Optional<Integer> cancelAt) {
            this.cancelAt = cancelAt;
            return this;
        }

        @Override
        public CreateBillingSubscriptionsRequestBody build() {
            return new CreateBillingSubscriptionsRequestBody(this.cancelAt, this.cancelAtPeriodEnd, this.currency, this.customerExternalId, this.defaultPaymentMethodId, this.discounts, this.expiredAt, this.interval, this.metadata, this.periodEnd, this.periodStart, this.productExternalIds, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.trialEndSetting, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingSubscriptionsRequestBody build();

        public _FinalStage cancelAt(Optional<Integer> var1);

        public _FinalStage cancelAt(Integer var1);

        public _FinalStage defaultPaymentMethodId(Optional<String> var1);

        public _FinalStage defaultPaymentMethodId(String var1);

        public _FinalStage discounts(List<BillingSubscriptionDiscount> var1);

        public _FinalStage addDiscounts(BillingSubscriptionDiscount var1);

        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscount> var1);

        public _FinalStage interval(Optional<String> var1);

        public _FinalStage interval(String var1);

        public _FinalStage metadata(Optional<Map<String, JsonNode>> var1);

        public _FinalStage metadata(Map<String, JsonNode> var1);

        public _FinalStage periodEnd(Optional<Integer> var1);

        public _FinalStage periodEnd(Integer var1);

        public _FinalStage periodStart(Optional<Integer> var1);

        public _FinalStage periodStart(Integer var1);

        public _FinalStage productExternalIds(List<BillingProductPricing> var1);

        public _FinalStage addProductExternalIds(BillingProductPricing var1);

        public _FinalStage addAllProductExternalIds(List<BillingProductPricing> var1);

        public _FinalStage status(Optional<String> var1);

        public _FinalStage status(String var1);

        public _FinalStage trialEnd(Optional<Integer> var1);

        public _FinalStage trialEnd(Integer var1);

        public _FinalStage trialEndSetting(Optional<CreateBillingSubscriptionsRequestBodyTrialEndSetting> var1);

        public _FinalStage trialEndSetting(CreateBillingSubscriptionsRequestBodyTrialEndSetting var1);
    }

    public static interface TotalPriceStage {
        public _FinalStage totalPrice(int var1);
    }

    public static interface SubscriptionExternalIdStage {
        public TotalPriceStage subscriptionExternalId(@NotNull String var1);
    }

    public static interface ExpiredAtStage {
        public SubscriptionExternalIdStage expiredAt(@NotNull OffsetDateTime var1);
    }

    public static interface CustomerExternalIdStage {
        public ExpiredAtStage customerExternalId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public CustomerExternalIdStage currency(@NotNull String var1);
    }

    public static interface CancelAtPeriodEndStage {
        public CurrencyStage cancelAtPeriodEnd(boolean var1);

        public Builder from(CreateBillingSubscriptionsRequestBody var1);
    }
}

