/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.SearchBillingPricesRequestUsageType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchBillingPricesRequest {
    private final Optional<String> ids;
    private final Optional<String> q;
    private final Optional<String> interval;
    private final Optional<SearchBillingPricesRequestUsageType> usageType;
    private final Optional<Integer> price;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private SearchBillingPricesRequest(Optional<String> ids, Optional<String> q, Optional<String> interval, Optional<SearchBillingPricesRequestUsageType> usageType, Optional<Integer> price, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.q = q;
        this.interval = interval;
        this.usageType = usageType;
        this.price = price;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ids")
    public Optional<String> getIds() {
        return this.ids;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @JsonProperty(value="usage_type")
    public Optional<SearchBillingPricesRequestUsageType> getUsageType() {
        return this.usageType;
    }

    @JsonProperty(value="price")
    public Optional<Integer> getPrice() {
        return this.price;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchBillingPricesRequest && this.equalTo((SearchBillingPricesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchBillingPricesRequest other) {
        return this.ids.equals(other.ids) && this.q.equals(other.q) && this.interval.equals(other.interval) && this.usageType.equals(other.usageType) && this.price.equals(other.price) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.q, this.interval, this.usageType, this.price, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> ids = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<String> interval = Optional.empty();
        private Optional<SearchBillingPricesRequestUsageType> usageType = Optional.empty();
        private Optional<Integer> price = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchBillingPricesRequest other) {
            this.ids(other.getIds());
            this.q(other.getQ());
            this.interval(other.getInterval());
            this.usageType(other.getUsageType());
            this.price(other.getPrice());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="interval", nulls=Nulls.SKIP)
        public Builder interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        @JsonSetter(value="usage_type", nulls=Nulls.SKIP)
        public Builder usageType(Optional<SearchBillingPricesRequestUsageType> usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder usageType(SearchBillingPricesRequestUsageType usageType) {
            this.usageType = Optional.ofNullable(usageType);
            return this;
        }

        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public Builder price(Optional<Integer> price) {
            this.price = price;
            return this;
        }

        public Builder price(Integer price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public SearchBillingPricesRequest build() {
            return new SearchBillingPricesRequest(this.ids, this.q, this.interval, this.usageType, this.price, this.limit, this.offset, this.additionalProperties);
        }
    }
}

