/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.checkout.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutDataRequestBody {
    private final String companyId;
    private final Optional<String> selectedPlanId;
    private final Map<String, Object> additionalProperties;

    private CheckoutDataRequestBody(String companyId, Optional<String> selectedPlanId, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.selectedPlanId = selectedPlanId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="selected_plan_id")
    public Optional<String> getSelectedPlanId() {
        return this.selectedPlanId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutDataRequestBody && this.equalTo((CheckoutDataRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutDataRequestBody other) {
        return this.companyId.equals(other.companyId) && this.selectedPlanId.equals(other.selectedPlanId);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.selectedPlanId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    _FinalStage {
        private String companyId;
        private Optional<String> selectedPlanId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CheckoutDataRequestBody other) {
            this.companyId(other.getCompanyId());
            this.selectedPlanId(other.getSelectedPlanId());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        public _FinalStage selectedPlanId(String selectedPlanId) {
            this.selectedPlanId = Optional.ofNullable(selectedPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="selected_plan_id", nulls=Nulls.SKIP)
        public _FinalStage selectedPlanId(Optional<String> selectedPlanId) {
            this.selectedPlanId = selectedPlanId;
            return this;
        }

        @Override
        public CheckoutDataRequestBody build() {
            return new CheckoutDataRequestBody(this.companyId, this.selectedPlanId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CheckoutDataRequestBody build();

        public _FinalStage selectedPlanId(Optional<String> var1);

        public _FinalStage selectedPlanId(String var1);
    }

    public static interface CompanyIdStage {
        public _FinalStage companyId(@NotNull String var1);

        public Builder from(CheckoutDataRequestBody var1);
    }
}

