/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.entitlements.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListFeatureCompaniesParams {
    private final Optional<String> featureId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<String> q;
    private final Map<String, Object> additionalProperties;

    private ListFeatureCompaniesParams(Optional<String> featureId, Optional<Integer> limit, Optional<Integer> offset, Optional<String> q, Map<String, Object> additionalProperties) {
        this.featureId = featureId;
        this.limit = limit;
        this.offset = offset;
        this.q = q;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="feature_id")
    public Optional<String> getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListFeatureCompaniesParams && this.equalTo((ListFeatureCompaniesParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListFeatureCompaniesParams other) {
        return this.featureId.equals(other.featureId) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.q.equals(other.q);
    }

    public int hashCode() {
        return Objects.hash(this.featureId, this.limit, this.offset, this.q);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> featureId = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<String> q = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListFeatureCompaniesParams other) {
            this.featureId(other.getFeatureId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.q(other.getQ());
            return this;
        }

        @JsonSetter(value="feature_id", nulls=Nulls.SKIP)
        public Builder featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        public Builder featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        public ListFeatureCompaniesParams build() {
            return new ListFeatureCompaniesParams(this.featureId, this.limit, this.offset, this.q, this.additionalProperties);
        }
    }
}

