/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plangroups.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CustomPlanConfig;
import com.schematic.api.types.OrderedPlansInGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreatePlanGroupRequestBody {
    private final List<String> addOnIds;
    private final Optional<CustomPlanConfig> customPlanConfig;
    private final Optional<String> customPlanId;
    private final Optional<String> defaultPlanId;
    private final List<OrderedPlansInGroup> orderedPlans;
    private final Optional<Integer> trialDays;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private CreatePlanGroupRequestBody(List<String> addOnIds, Optional<CustomPlanConfig> customPlanConfig, Optional<String> customPlanId, Optional<String> defaultPlanId, List<OrderedPlansInGroup> orderedPlans, Optional<Integer> trialDays, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOnIds = addOnIds;
        this.customPlanConfig = customPlanConfig;
        this.customPlanId = customPlanId;
        this.defaultPlanId = defaultPlanId;
        this.orderedPlans = orderedPlans;
        this.trialDays = trialDays;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_ids")
    public List<String> getAddOnIds() {
        return this.addOnIds;
    }

    @JsonProperty(value="custom_plan_config")
    public Optional<CustomPlanConfig> getCustomPlanConfig() {
        return this.customPlanConfig;
    }

    @JsonProperty(value="custom_plan_id")
    public Optional<String> getCustomPlanId() {
        return this.customPlanId;
    }

    @JsonProperty(value="default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return this.defaultPlanId;
    }

    @JsonProperty(value="ordered_plans")
    public List<OrderedPlansInGroup> getOrderedPlans() {
        return this.orderedPlans;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreatePlanGroupRequestBody && this.equalTo((CreatePlanGroupRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePlanGroupRequestBody other) {
        return this.addOnIds.equals(other.addOnIds) && this.customPlanConfig.equals(other.customPlanConfig) && this.customPlanId.equals(other.customPlanId) && this.defaultPlanId.equals(other.defaultPlanId) && this.orderedPlans.equals(other.orderedPlans) && this.trialDays.equals(other.trialDays) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOnIds, this.customPlanConfig, this.customPlanId, this.defaultPlanId, this.orderedPlans, this.trialDays, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> addOnIds = new ArrayList<String>();
        private Optional<CustomPlanConfig> customPlanConfig = Optional.empty();
        private Optional<String> customPlanId = Optional.empty();
        private Optional<String> defaultPlanId = Optional.empty();
        private List<OrderedPlansInGroup> orderedPlans = new ArrayList<OrderedPlansInGroup>();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreatePlanGroupRequestBody other) {
            this.addOnIds(other.getAddOnIds());
            this.customPlanConfig(other.getCustomPlanConfig());
            this.customPlanId(other.getCustomPlanId());
            this.defaultPlanId(other.getDefaultPlanId());
            this.orderedPlans(other.getOrderedPlans());
            this.trialDays(other.getTrialDays());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @JsonSetter(value="add_on_ids", nulls=Nulls.SKIP)
        public Builder addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        public Builder addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        public Builder addAllAddOnIds(List<String> addOnIds) {
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @JsonSetter(value="custom_plan_config", nulls=Nulls.SKIP)
        public Builder customPlanConfig(Optional<CustomPlanConfig> customPlanConfig) {
            this.customPlanConfig = customPlanConfig;
            return this;
        }

        public Builder customPlanConfig(CustomPlanConfig customPlanConfig) {
            this.customPlanConfig = Optional.ofNullable(customPlanConfig);
            return this;
        }

        @JsonSetter(value="custom_plan_id", nulls=Nulls.SKIP)
        public Builder customPlanId(Optional<String> customPlanId) {
            this.customPlanId = customPlanId;
            return this;
        }

        public Builder customPlanId(String customPlanId) {
            this.customPlanId = Optional.ofNullable(customPlanId);
            return this;
        }

        @JsonSetter(value="default_plan_id", nulls=Nulls.SKIP)
        public Builder defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        public Builder defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @JsonSetter(value="ordered_plans", nulls=Nulls.SKIP)
        public Builder orderedPlans(List<OrderedPlansInGroup> orderedPlans) {
            this.orderedPlans.clear();
            this.orderedPlans.addAll(orderedPlans);
            return this;
        }

        public Builder addOrderedPlans(OrderedPlansInGroup orderedPlans) {
            this.orderedPlans.add(orderedPlans);
            return this;
        }

        public Builder addAllOrderedPlans(List<OrderedPlansInGroup> orderedPlans) {
            this.orderedPlans.addAll(orderedPlans);
            return this;
        }

        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public Builder trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        public Builder trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public Builder trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        public Builder trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        public CreatePlanGroupRequestBody build() {
            return new CreatePlanGroupRequestBody(this.addOnIds, this.customPlanConfig, this.customPlanId, this.defaultPlanId, this.orderedPlans, this.trialDays, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }
}

