/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingCustomerSubscription;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCustomerWithSubscriptionsResponseData {
    private final Optional<String> companyId;
    private final Optional<OffsetDateTime> deletedAt;
    private final String email;
    private final String externalId;
    private final boolean failedToImport;
    private final String id;
    private final String name;
    private final List<BillingCustomerSubscription> subscriptions;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private BillingCustomerWithSubscriptionsResponseData(Optional<String> companyId, Optional<OffsetDateTime> deletedAt, String email, String externalId, boolean failedToImport, String id, String name, List<BillingCustomerSubscription> subscriptions, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.deletedAt = deletedAt;
        this.email = email;
        this.externalId = externalId;
        this.failedToImport = failedToImport;
        this.id = id;
        this.name = name;
        this.subscriptions = subscriptions;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="deleted_at")
    public Optional<OffsetDateTime> getDeletedAt() {
        return this.deletedAt;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="failed_to_import")
    public boolean getFailedToImport() {
        return this.failedToImport;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="subscriptions")
    public List<BillingCustomerSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCustomerWithSubscriptionsResponseData && this.equalTo((BillingCustomerWithSubscriptionsResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCustomerWithSubscriptionsResponseData other) {
        return this.companyId.equals(other.companyId) && this.deletedAt.equals(other.deletedAt) && this.email.equals(other.email) && this.externalId.equals(other.externalId) && this.failedToImport == other.failedToImport && this.id.equals(other.id) && this.name.equals(other.name) && this.subscriptions.equals(other.subscriptions) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.deletedAt, this.email, this.externalId, this.failedToImport, this.id, this.name, this.subscriptions, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EmailStage,
    ExternalIdStage,
    FailedToImportStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private String email;
        private String externalId;
        private boolean failedToImport;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private List<BillingCustomerSubscription> subscriptions = new ArrayList<BillingCustomerSubscription>();
        private Optional<OffsetDateTime> deletedAt = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCustomerWithSubscriptionsResponseData other) {
            this.companyId(other.getCompanyId());
            this.deletedAt(other.getDeletedAt());
            this.email(other.getEmail());
            this.externalId(other.getExternalId());
            this.failedToImport(other.getFailedToImport());
            this.id(other.getId());
            this.name(other.getName());
            this.subscriptions(other.getSubscriptions());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public ExternalIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public FailedToImportStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="failed_to_import")
        public IdStage failedToImport(boolean failedToImport) {
            this.failedToImport = failedToImport;
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllSubscriptions(List<BillingCustomerSubscription> subscriptions) {
            this.subscriptions.addAll(subscriptions);
            return this;
        }

        @Override
        public _FinalStage addSubscriptions(BillingCustomerSubscription subscriptions) {
            this.subscriptions.add(subscriptions);
            return this;
        }

        @Override
        @JsonSetter(value="subscriptions", nulls=Nulls.SKIP)
        public _FinalStage subscriptions(List<BillingCustomerSubscription> subscriptions) {
            this.subscriptions.clear();
            this.subscriptions.addAll(subscriptions);
            return this;
        }

        @Override
        public _FinalStage deletedAt(OffsetDateTime deletedAt) {
            this.deletedAt = Optional.ofNullable(deletedAt);
            return this;
        }

        @Override
        @JsonSetter(value="deleted_at", nulls=Nulls.SKIP)
        public _FinalStage deletedAt(Optional<OffsetDateTime> deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public BillingCustomerWithSubscriptionsResponseData build() {
            return new BillingCustomerWithSubscriptionsResponseData(this.companyId, this.deletedAt, this.email, this.externalId, this.failedToImport, this.id, this.name, this.subscriptions, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCustomerWithSubscriptionsResponseData build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage deletedAt(Optional<OffsetDateTime> var1);

        public _FinalStage deletedAt(OffsetDateTime var1);

        public _FinalStage subscriptions(List<BillingCustomerSubscription> var1);

        public _FinalStage addSubscriptions(BillingCustomerSubscription var1);

        public _FinalStage addAllSubscriptions(List<BillingCustomerSubscription> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface FailedToImportStage {
        public IdStage failedToImport(boolean var1);
    }

    public static interface ExternalIdStage {
        public FailedToImportStage externalId(@NotNull String var1);
    }

    public static interface EmailStage {
        public ExternalIdStage email(@NotNull String var1);

        public Builder from(BillingCustomerWithSubscriptionsResponseData var1);
    }
}

