/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingProductForSubscriptionResponseData;
import com.schematic.api.types.BillingSubscriptionDiscountView;
import com.schematic.api.types.InvoiceResponseData;
import com.schematic.api.types.PaymentMethodResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingSubscriptionView {
    private final Optional<Integer> cancelAt;
    private final boolean cancelAtPeriodEnd;
    private final Optional<String> companyId;
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String customerExternalId;
    private final Optional<String> defaultPaymentMethodId;
    private final List<BillingSubscriptionDiscountView> discounts;
    private final Optional<OffsetDateTime> expiredAt;
    private final String id;
    private final String interval;
    private final Optional<InvoiceResponseData> latestInvoice;
    private final Optional<Map<String, JsonNode>> metadata;
    private final Optional<PaymentMethodResponseData> paymentMethod;
    private final int periodEnd;
    private final int periodStart;
    private final List<BillingProductForSubscriptionResponseData> products;
    private final String status;
    private final String subscriptionExternalId;
    private final int totalPrice;
    private final Optional<Integer> trialEnd;
    private final Optional<String> trialEndSetting;
    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionView(Optional<Integer> cancelAt, boolean cancelAtPeriodEnd, Optional<String> companyId, OffsetDateTime createdAt, String currency, String customerExternalId, Optional<String> defaultPaymentMethodId, List<BillingSubscriptionDiscountView> discounts, Optional<OffsetDateTime> expiredAt, String id, String interval, Optional<InvoiceResponseData> latestInvoice, Optional<Map<String, JsonNode>> metadata, Optional<PaymentMethodResponseData> paymentMethod, int periodEnd, int periodStart, List<BillingProductForSubscriptionResponseData> products, String status, String subscriptionExternalId, int totalPrice, Optional<Integer> trialEnd, Optional<String> trialEndSetting, Map<String, Object> additionalProperties) {
        this.cancelAt = cancelAt;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        this.discounts = discounts;
        this.expiredAt = expiredAt;
        this.id = id;
        this.interval = interval;
        this.latestInvoice = latestInvoice;
        this.metadata = metadata;
        this.paymentMethod = paymentMethod;
        this.periodEnd = periodEnd;
        this.periodStart = periodStart;
        this.products = products;
        this.status = status;
        this.subscriptionExternalId = subscriptionExternalId;
        this.totalPrice = totalPrice;
        this.trialEnd = trialEnd;
        this.trialEndSetting = trialEndSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cancel_at")
    public Optional<Integer> getCancelAt() {
        return this.cancelAt;
    }

    @JsonProperty(value="cancel_at_period_end")
    public boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="default_payment_method_id")
    public Optional<String> getDefaultPaymentMethodId() {
        return this.defaultPaymentMethodId;
    }

    @JsonProperty(value="discounts")
    public List<BillingSubscriptionDiscountView> getDiscounts() {
        return this.discounts;
    }

    @JsonProperty(value="expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="latest_invoice")
    public Optional<InvoiceResponseData> getLatestInvoice() {
        return this.latestInvoice;
    }

    @JsonProperty(value="metadata")
    public Optional<Map<String, JsonNode>> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="payment_method")
    public Optional<PaymentMethodResponseData> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="period_end")
    public int getPeriodEnd() {
        return this.periodEnd;
    }

    @JsonProperty(value="period_start")
    public int getPeriodStart() {
        return this.periodStart;
    }

    @JsonProperty(value="products")
    public List<BillingProductForSubscriptionResponseData> getProducts() {
        return this.products;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="subscription_external_id")
    public String getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    @JsonProperty(value="total_price")
    public int getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="trial_end")
    public Optional<Integer> getTrialEnd() {
        return this.trialEnd;
    }

    @JsonProperty(value="trial_end_setting")
    public Optional<String> getTrialEndSetting() {
        return this.trialEndSetting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingSubscriptionView && this.equalTo((BillingSubscriptionView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionView other) {
        return this.cancelAt.equals(other.cancelAt) && this.cancelAtPeriodEnd == other.cancelAtPeriodEnd && this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.customerExternalId.equals(other.customerExternalId) && this.defaultPaymentMethodId.equals(other.defaultPaymentMethodId) && this.discounts.equals(other.discounts) && this.expiredAt.equals(other.expiredAt) && this.id.equals(other.id) && this.interval.equals(other.interval) && this.latestInvoice.equals(other.latestInvoice) && this.metadata.equals(other.metadata) && this.paymentMethod.equals(other.paymentMethod) && this.periodEnd == other.periodEnd && this.periodStart == other.periodStart && this.products.equals(other.products) && this.status.equals(other.status) && this.subscriptionExternalId.equals(other.subscriptionExternalId) && this.totalPrice == other.totalPrice && this.trialEnd.equals(other.trialEnd) && this.trialEndSetting.equals(other.trialEndSetting);
    }

    public int hashCode() {
        return Objects.hash(this.cancelAt, this.cancelAtPeriodEnd, this.companyId, this.createdAt, this.currency, this.customerExternalId, this.defaultPaymentMethodId, this.discounts, this.expiredAt, this.id, this.interval, this.latestInvoice, this.metadata, this.paymentMethod, this.periodEnd, this.periodStart, this.products, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.trialEndSetting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CancelAtPeriodEndStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CancelAtPeriodEndStage,
    CreatedAtStage,
    CurrencyStage,
    CustomerExternalIdStage,
    IdStage,
    IntervalStage,
    PeriodEndStage,
    PeriodStartStage,
    StatusStage,
    SubscriptionExternalIdStage,
    TotalPriceStage,
    _FinalStage {
        private boolean cancelAtPeriodEnd;
        private OffsetDateTime createdAt;
        private String currency;
        private String customerExternalId;
        private String id;
        private String interval;
        private int periodEnd;
        private int periodStart;
        private String status;
        private String subscriptionExternalId;
        private int totalPrice;
        private Optional<String> trialEndSetting = Optional.empty();
        private Optional<Integer> trialEnd = Optional.empty();
        private List<BillingProductForSubscriptionResponseData> products = new ArrayList<BillingProductForSubscriptionResponseData>();
        private Optional<PaymentMethodResponseData> paymentMethod = Optional.empty();
        private Optional<Map<String, JsonNode>> metadata = Optional.empty();
        private Optional<InvoiceResponseData> latestInvoice = Optional.empty();
        private Optional<OffsetDateTime> expiredAt = Optional.empty();
        private List<BillingSubscriptionDiscountView> discounts = new ArrayList<BillingSubscriptionDiscountView>();
        private Optional<String> defaultPaymentMethodId = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<Integer> cancelAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingSubscriptionView other) {
            this.cancelAt(other.getCancelAt());
            this.cancelAtPeriodEnd(other.getCancelAtPeriodEnd());
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.customerExternalId(other.getCustomerExternalId());
            this.defaultPaymentMethodId(other.getDefaultPaymentMethodId());
            this.discounts(other.getDiscounts());
            this.expiredAt(other.getExpiredAt());
            this.id(other.getId());
            this.interval(other.getInterval());
            this.latestInvoice(other.getLatestInvoice());
            this.metadata(other.getMetadata());
            this.paymentMethod(other.getPaymentMethod());
            this.periodEnd(other.getPeriodEnd());
            this.periodStart(other.getPeriodStart());
            this.products(other.getProducts());
            this.status(other.getStatus());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            this.totalPrice(other.getTotalPrice());
            this.trialEnd(other.getTrialEnd());
            this.trialEndSetting(other.getTrialEndSetting());
            return this;
        }

        @Override
        @JsonSetter(value="cancel_at_period_end")
        public CreatedAtStage cancelAtPeriodEnd(boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public IdStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public PeriodEndStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="period_end")
        public PeriodStartStage periodEnd(int periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        @Override
        @JsonSetter(value="period_start")
        public StatusStage periodStart(int periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public SubscriptionExternalIdStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id")
        public TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId = Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage trialEndSetting(String trialEndSetting) {
            this.trialEndSetting = Optional.ofNullable(trialEndSetting);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end_setting", nulls=Nulls.SKIP)
        public _FinalStage trialEndSetting(Optional<String> trialEndSetting) {
            this.trialEndSetting = trialEndSetting;
            return this;
        }

        @Override
        public _FinalStage trialEnd(Integer trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end", nulls=Nulls.SKIP)
        public _FinalStage trialEnd(Optional<Integer> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @Override
        public _FinalStage addAllProducts(List<BillingProductForSubscriptionResponseData> products) {
            this.products.addAll(products);
            return this;
        }

        @Override
        public _FinalStage addProducts(BillingProductForSubscriptionResponseData products) {
            this.products.add(products);
            return this;
        }

        @Override
        @JsonSetter(value="products", nulls=Nulls.SKIP)
        public _FinalStage products(List<BillingProductForSubscriptionResponseData> products) {
            this.products.clear();
            this.products.addAll(products);
            return this;
        }

        @Override
        public _FinalStage paymentMethod(PaymentMethodResponseData paymentMethod) {
            this.paymentMethod = Optional.ofNullable(paymentMethod);
            return this;
        }

        @Override
        @JsonSetter(value="payment_method", nulls=Nulls.SKIP)
        public _FinalStage paymentMethod(Optional<PaymentMethodResponseData> paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, JsonNode> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, JsonNode>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage latestInvoice(InvoiceResponseData latestInvoice) {
            this.latestInvoice = Optional.ofNullable(latestInvoice);
            return this;
        }

        @Override
        @JsonSetter(value="latest_invoice", nulls=Nulls.SKIP)
        public _FinalStage latestInvoice(Optional<InvoiceResponseData> latestInvoice) {
            this.latestInvoice = latestInvoice;
            return this;
        }

        @Override
        public _FinalStage expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @Override
        @JsonSetter(value="expired_at", nulls=Nulls.SKIP)
        public _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        @Override
        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscountView> discounts) {
            this.discounts.addAll(discounts);
            return this;
        }

        @Override
        public _FinalStage addDiscounts(BillingSubscriptionDiscountView discounts) {
            this.discounts.add(discounts);
            return this;
        }

        @Override
        @JsonSetter(value="discounts", nulls=Nulls.SKIP)
        public _FinalStage discounts(List<BillingSubscriptionDiscountView> discounts) {
            this.discounts.clear();
            this.discounts.addAll(discounts);
            return this;
        }

        @Override
        public _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId) {
            this.defaultPaymentMethodId = Optional.ofNullable(defaultPaymentMethodId);
            return this;
        }

        @Override
        @JsonSetter(value="default_payment_method_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId) {
            this.defaultPaymentMethodId = defaultPaymentMethodId;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public _FinalStage cancelAt(Integer cancelAt) {
            this.cancelAt = Optional.ofNullable(cancelAt);
            return this;
        }

        @Override
        @JsonSetter(value="cancel_at", nulls=Nulls.SKIP)
        public _FinalStage cancelAt(Optional<Integer> cancelAt) {
            this.cancelAt = cancelAt;
            return this;
        }

        @Override
        public BillingSubscriptionView build() {
            return new BillingSubscriptionView(this.cancelAt, this.cancelAtPeriodEnd, this.companyId, this.createdAt, this.currency, this.customerExternalId, this.defaultPaymentMethodId, this.discounts, this.expiredAt, this.id, this.interval, this.latestInvoice, this.metadata, this.paymentMethod, this.periodEnd, this.periodStart, this.products, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.trialEndSetting, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingSubscriptionView build();

        public _FinalStage cancelAt(Optional<Integer> var1);

        public _FinalStage cancelAt(Integer var1);

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage defaultPaymentMethodId(Optional<String> var1);

        public _FinalStage defaultPaymentMethodId(String var1);

        public _FinalStage discounts(List<BillingSubscriptionDiscountView> var1);

        public _FinalStage addDiscounts(BillingSubscriptionDiscountView var1);

        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscountView> var1);

        public _FinalStage expiredAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiredAt(OffsetDateTime var1);

        public _FinalStage latestInvoice(Optional<InvoiceResponseData> var1);

        public _FinalStage latestInvoice(InvoiceResponseData var1);

        public _FinalStage metadata(Optional<Map<String, JsonNode>> var1);

        public _FinalStage metadata(Map<String, JsonNode> var1);

        public _FinalStage paymentMethod(Optional<PaymentMethodResponseData> var1);

        public _FinalStage paymentMethod(PaymentMethodResponseData var1);

        public _FinalStage products(List<BillingProductForSubscriptionResponseData> var1);

        public _FinalStage addProducts(BillingProductForSubscriptionResponseData var1);

        public _FinalStage addAllProducts(List<BillingProductForSubscriptionResponseData> var1);

        public _FinalStage trialEnd(Optional<Integer> var1);

        public _FinalStage trialEnd(Integer var1);

        public _FinalStage trialEndSetting(Optional<String> var1);

        public _FinalStage trialEndSetting(String var1);
    }

    public static interface TotalPriceStage {
        public _FinalStage totalPrice(int var1);
    }

    public static interface SubscriptionExternalIdStage {
        public TotalPriceStage subscriptionExternalId(@NotNull String var1);
    }

    public static interface StatusStage {
        public SubscriptionExternalIdStage status(@NotNull String var1);
    }

    public static interface PeriodStartStage {
        public StatusStage periodStart(int var1);
    }

    public static interface PeriodEndStage {
        public PeriodStartStage periodEnd(int var1);
    }

    public static interface IntervalStage {
        public PeriodEndStage interval(@NotNull String var1);
    }

    public static interface IdStage {
        public IntervalStage id(@NotNull String var1);
    }

    public static interface CustomerExternalIdStage {
        public IdStage customerExternalId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public CustomerExternalIdStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CancelAtPeriodEndStage {
        public CreatedAtStage cancelAtPeriodEnd(boolean var1);

        public Builder from(BillingSubscriptionView var1);
    }
}

