/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CrmDealLineItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyCrmDealsResponseData {
    private final String dealArr;
    private final String dealExternalId;
    private final String dealMrr;
    private final Optional<String> dealName;
    private final List<CrmDealLineItem> lineItems;
    private final Map<String, Object> additionalProperties;

    private CompanyCrmDealsResponseData(String dealArr, String dealExternalId, String dealMrr, Optional<String> dealName, List<CrmDealLineItem> lineItems, Map<String, Object> additionalProperties) {
        this.dealArr = dealArr;
        this.dealExternalId = dealExternalId;
        this.dealMrr = dealMrr;
        this.dealName = dealName;
        this.lineItems = lineItems;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="deal_arr")
    public String getDealArr() {
        return this.dealArr;
    }

    @JsonProperty(value="deal_external_id")
    public String getDealExternalId() {
        return this.dealExternalId;
    }

    @JsonProperty(value="deal_mrr")
    public String getDealMrr() {
        return this.dealMrr;
    }

    @JsonProperty(value="deal_name")
    public Optional<String> getDealName() {
        return this.dealName;
    }

    @JsonProperty(value="line_items")
    public List<CrmDealLineItem> getLineItems() {
        return this.lineItems;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyCrmDealsResponseData && this.equalTo((CompanyCrmDealsResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyCrmDealsResponseData other) {
        return this.dealArr.equals(other.dealArr) && this.dealExternalId.equals(other.dealExternalId) && this.dealMrr.equals(other.dealMrr) && this.dealName.equals(other.dealName) && this.lineItems.equals(other.lineItems);
    }

    public int hashCode() {
        return Objects.hash(this.dealArr, this.dealExternalId, this.dealMrr, this.dealName, this.lineItems);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DealArrStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DealArrStage,
    DealExternalIdStage,
    DealMrrStage,
    _FinalStage {
        private String dealArr;
        private String dealExternalId;
        private String dealMrr;
        private List<CrmDealLineItem> lineItems = new ArrayList<CrmDealLineItem>();
        private Optional<String> dealName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyCrmDealsResponseData other) {
            this.dealArr(other.getDealArr());
            this.dealExternalId(other.getDealExternalId());
            this.dealMrr(other.getDealMrr());
            this.dealName(other.getDealName());
            this.lineItems(other.getLineItems());
            return this;
        }

        @Override
        @JsonSetter(value="deal_arr")
        public DealExternalIdStage dealArr(@NotNull String dealArr) {
            this.dealArr = Objects.requireNonNull(dealArr, "dealArr must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deal_external_id")
        public DealMrrStage dealExternalId(@NotNull String dealExternalId) {
            this.dealExternalId = Objects.requireNonNull(dealExternalId, "dealExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deal_mrr")
        public _FinalStage dealMrr(@NotNull String dealMrr) {
            this.dealMrr = Objects.requireNonNull(dealMrr, "dealMrr must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllLineItems(List<CrmDealLineItem> lineItems) {
            this.lineItems.addAll(lineItems);
            return this;
        }

        @Override
        public _FinalStage addLineItems(CrmDealLineItem lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @Override
        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public _FinalStage lineItems(List<CrmDealLineItem> lineItems) {
            this.lineItems.clear();
            this.lineItems.addAll(lineItems);
            return this;
        }

        @Override
        public _FinalStage dealName(String dealName) {
            this.dealName = Optional.ofNullable(dealName);
            return this;
        }

        @Override
        @JsonSetter(value="deal_name", nulls=Nulls.SKIP)
        public _FinalStage dealName(Optional<String> dealName) {
            this.dealName = dealName;
            return this;
        }

        @Override
        public CompanyCrmDealsResponseData build() {
            return new CompanyCrmDealsResponseData(this.dealArr, this.dealExternalId, this.dealMrr, this.dealName, this.lineItems, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyCrmDealsResponseData build();

        public _FinalStage dealName(Optional<String> var1);

        public _FinalStage dealName(String var1);

        public _FinalStage lineItems(List<CrmDealLineItem> var1);

        public _FinalStage addLineItems(CrmDealLineItem var1);

        public _FinalStage addAllLineItems(List<CrmDealLineItem> var1);
    }

    public static interface DealMrrStage {
        public _FinalStage dealMrr(@NotNull String var1);
    }

    public static interface DealExternalIdStage {
        public DealMrrStage dealExternalId(@NotNull String var1);
    }

    public static interface DealArrStage {
        public DealExternalIdStage dealArr(@NotNull String var1);

        public Builder from(CompanyCrmDealsResponseData var1);
    }
}

