/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingProductForSubscriptionResponseData;
import com.schematic.api.types.BillingSubscriptionDiscountView;
import com.schematic.api.types.InvoiceResponseData;
import com.schematic.api.types.PaymentMethodResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanySubscriptionResponseData {
    private final Optional<OffsetDateTime> cancelAt;
    private final boolean cancelAtPeriodEnd;
    private final String currency;
    private final String customerExternalId;
    private final List<BillingSubscriptionDiscountView> discounts;
    private final Optional<OffsetDateTime> expiredAt;
    private final String interval;
    private final Optional<InvoiceResponseData> latestInvoice;
    private final Optional<PaymentMethodResponseData> paymentMethod;
    private final List<BillingProductForSubscriptionResponseData> products;
    private final String status;
    private final String subscriptionExternalId;
    private final int totalPrice;
    private final Optional<OffsetDateTime> trialEnd;
    private final Map<String, Object> additionalProperties;

    private CompanySubscriptionResponseData(Optional<OffsetDateTime> cancelAt, boolean cancelAtPeriodEnd, String currency, String customerExternalId, List<BillingSubscriptionDiscountView> discounts, Optional<OffsetDateTime> expiredAt, String interval, Optional<InvoiceResponseData> latestInvoice, Optional<PaymentMethodResponseData> paymentMethod, List<BillingProductForSubscriptionResponseData> products, String status, String subscriptionExternalId, int totalPrice, Optional<OffsetDateTime> trialEnd, Map<String, Object> additionalProperties) {
        this.cancelAt = cancelAt;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.discounts = discounts;
        this.expiredAt = expiredAt;
        this.interval = interval;
        this.latestInvoice = latestInvoice;
        this.paymentMethod = paymentMethod;
        this.products = products;
        this.status = status;
        this.subscriptionExternalId = subscriptionExternalId;
        this.totalPrice = totalPrice;
        this.trialEnd = trialEnd;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cancel_at")
    public Optional<OffsetDateTime> getCancelAt() {
        return this.cancelAt;
    }

    @JsonProperty(value="cancel_at_period_end")
    public boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="discounts")
    public List<BillingSubscriptionDiscountView> getDiscounts() {
        return this.discounts;
    }

    @JsonProperty(value="expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="latest_invoice")
    public Optional<InvoiceResponseData> getLatestInvoice() {
        return this.latestInvoice;
    }

    @JsonProperty(value="payment_method")
    public Optional<PaymentMethodResponseData> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="products")
    public List<BillingProductForSubscriptionResponseData> getProducts() {
        return this.products;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="subscription_external_id")
    public String getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    @JsonProperty(value="total_price")
    public int getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="trial_end")
    public Optional<OffsetDateTime> getTrialEnd() {
        return this.trialEnd;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanySubscriptionResponseData && this.equalTo((CompanySubscriptionResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanySubscriptionResponseData other) {
        return this.cancelAt.equals(other.cancelAt) && this.cancelAtPeriodEnd == other.cancelAtPeriodEnd && this.currency.equals(other.currency) && this.customerExternalId.equals(other.customerExternalId) && this.discounts.equals(other.discounts) && this.expiredAt.equals(other.expiredAt) && this.interval.equals(other.interval) && this.latestInvoice.equals(other.latestInvoice) && this.paymentMethod.equals(other.paymentMethod) && this.products.equals(other.products) && this.status.equals(other.status) && this.subscriptionExternalId.equals(other.subscriptionExternalId) && this.totalPrice == other.totalPrice && this.trialEnd.equals(other.trialEnd);
    }

    public int hashCode() {
        return Objects.hash(this.cancelAt, this.cancelAtPeriodEnd, this.currency, this.customerExternalId, this.discounts, this.expiredAt, this.interval, this.latestInvoice, this.paymentMethod, this.products, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CancelAtPeriodEndStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CancelAtPeriodEndStage,
    CurrencyStage,
    CustomerExternalIdStage,
    IntervalStage,
    StatusStage,
    SubscriptionExternalIdStage,
    TotalPriceStage,
    _FinalStage {
        private boolean cancelAtPeriodEnd;
        private String currency;
        private String customerExternalId;
        private String interval;
        private String status;
        private String subscriptionExternalId;
        private int totalPrice;
        private Optional<OffsetDateTime> trialEnd = Optional.empty();
        private List<BillingProductForSubscriptionResponseData> products = new ArrayList<BillingProductForSubscriptionResponseData>();
        private Optional<PaymentMethodResponseData> paymentMethod = Optional.empty();
        private Optional<InvoiceResponseData> latestInvoice = Optional.empty();
        private Optional<OffsetDateTime> expiredAt = Optional.empty();
        private List<BillingSubscriptionDiscountView> discounts = new ArrayList<BillingSubscriptionDiscountView>();
        private Optional<OffsetDateTime> cancelAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanySubscriptionResponseData other) {
            this.cancelAt(other.getCancelAt());
            this.cancelAtPeriodEnd(other.getCancelAtPeriodEnd());
            this.currency(other.getCurrency());
            this.customerExternalId(other.getCustomerExternalId());
            this.discounts(other.getDiscounts());
            this.expiredAt(other.getExpiredAt());
            this.interval(other.getInterval());
            this.latestInvoice(other.getLatestInvoice());
            this.paymentMethod(other.getPaymentMethod());
            this.products(other.getProducts());
            this.status(other.getStatus());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            this.totalPrice(other.getTotalPrice());
            this.trialEnd(other.getTrialEnd());
            return this;
        }

        @Override
        @JsonSetter(value="cancel_at_period_end")
        public CurrencyStage cancelAtPeriodEnd(boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public IntervalStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public StatusStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public SubscriptionExternalIdStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id")
        public TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId = Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage trialEnd(OffsetDateTime trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end", nulls=Nulls.SKIP)
        public _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @Override
        public _FinalStage addAllProducts(List<BillingProductForSubscriptionResponseData> products) {
            this.products.addAll(products);
            return this;
        }

        @Override
        public _FinalStage addProducts(BillingProductForSubscriptionResponseData products) {
            this.products.add(products);
            return this;
        }

        @Override
        @JsonSetter(value="products", nulls=Nulls.SKIP)
        public _FinalStage products(List<BillingProductForSubscriptionResponseData> products) {
            this.products.clear();
            this.products.addAll(products);
            return this;
        }

        @Override
        public _FinalStage paymentMethod(PaymentMethodResponseData paymentMethod) {
            this.paymentMethod = Optional.ofNullable(paymentMethod);
            return this;
        }

        @Override
        @JsonSetter(value="payment_method", nulls=Nulls.SKIP)
        public _FinalStage paymentMethod(Optional<PaymentMethodResponseData> paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @Override
        public _FinalStage latestInvoice(InvoiceResponseData latestInvoice) {
            this.latestInvoice = Optional.ofNullable(latestInvoice);
            return this;
        }

        @Override
        @JsonSetter(value="latest_invoice", nulls=Nulls.SKIP)
        public _FinalStage latestInvoice(Optional<InvoiceResponseData> latestInvoice) {
            this.latestInvoice = latestInvoice;
            return this;
        }

        @Override
        public _FinalStage expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @Override
        @JsonSetter(value="expired_at", nulls=Nulls.SKIP)
        public _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        @Override
        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscountView> discounts) {
            this.discounts.addAll(discounts);
            return this;
        }

        @Override
        public _FinalStage addDiscounts(BillingSubscriptionDiscountView discounts) {
            this.discounts.add(discounts);
            return this;
        }

        @Override
        @JsonSetter(value="discounts", nulls=Nulls.SKIP)
        public _FinalStage discounts(List<BillingSubscriptionDiscountView> discounts) {
            this.discounts.clear();
            this.discounts.addAll(discounts);
            return this;
        }

        @Override
        public _FinalStage cancelAt(OffsetDateTime cancelAt) {
            this.cancelAt = Optional.ofNullable(cancelAt);
            return this;
        }

        @Override
        @JsonSetter(value="cancel_at", nulls=Nulls.SKIP)
        public _FinalStage cancelAt(Optional<OffsetDateTime> cancelAt) {
            this.cancelAt = cancelAt;
            return this;
        }

        @Override
        public CompanySubscriptionResponseData build() {
            return new CompanySubscriptionResponseData(this.cancelAt, this.cancelAtPeriodEnd, this.currency, this.customerExternalId, this.discounts, this.expiredAt, this.interval, this.latestInvoice, this.paymentMethod, this.products, this.status, this.subscriptionExternalId, this.totalPrice, this.trialEnd, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanySubscriptionResponseData build();

        public _FinalStage cancelAt(Optional<OffsetDateTime> var1);

        public _FinalStage cancelAt(OffsetDateTime var1);

        public _FinalStage discounts(List<BillingSubscriptionDiscountView> var1);

        public _FinalStage addDiscounts(BillingSubscriptionDiscountView var1);

        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscountView> var1);

        public _FinalStage expiredAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiredAt(OffsetDateTime var1);

        public _FinalStage latestInvoice(Optional<InvoiceResponseData> var1);

        public _FinalStage latestInvoice(InvoiceResponseData var1);

        public _FinalStage paymentMethod(Optional<PaymentMethodResponseData> var1);

        public _FinalStage paymentMethod(PaymentMethodResponseData var1);

        public _FinalStage products(List<BillingProductForSubscriptionResponseData> var1);

        public _FinalStage addProducts(BillingProductForSubscriptionResponseData var1);

        public _FinalStage addAllProducts(List<BillingProductForSubscriptionResponseData> var1);

        public _FinalStage trialEnd(Optional<OffsetDateTime> var1);

        public _FinalStage trialEnd(OffsetDateTime var1);
    }

    public static interface TotalPriceStage {
        public _FinalStage totalPrice(int var1);
    }

    public static interface SubscriptionExternalIdStage {
        public TotalPriceStage subscriptionExternalId(@NotNull String var1);
    }

    public static interface StatusStage {
        public SubscriptionExternalIdStage status(@NotNull String var1);
    }

    public static interface IntervalStage {
        public StatusStage interval(@NotNull String var1);
    }

    public static interface CustomerExternalIdStage {
        public IntervalStage customerExternalId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public CustomerExternalIdStage currency(@NotNull String var1);
    }

    public static interface CancelAtPeriodEndStage {
        public CurrencyStage cancelAtPeriodEnd(boolean var1);

        public Builder from(CompanySubscriptionResponseData var1);
    }
}

