/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CrmDealLineItem {
    private final String billingFrequency;
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String description;
    private final Optional<Map<String, JsonNode>> discountPercentage;
    private final String id;
    private final String name;
    private final double price;
    private final int quantity;
    private final Optional<Integer> termMonth;
    private final Optional<Map<String, JsonNode>> totalDiscount;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private CrmDealLineItem(String billingFrequency, OffsetDateTime createdAt, String currency, String description, Optional<Map<String, JsonNode>> discountPercentage, String id, String name, double price, int quantity, Optional<Integer> termMonth, Optional<Map<String, JsonNode>> totalDiscount, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.billingFrequency = billingFrequency;
        this.createdAt = createdAt;
        this.currency = currency;
        this.description = description;
        this.discountPercentage = discountPercentage;
        this.id = id;
        this.name = name;
        this.price = price;
        this.quantity = quantity;
        this.termMonth = termMonth;
        this.totalDiscount = totalDiscount;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_frequency")
    public String getBillingFrequency() {
        return this.billingFrequency;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="discount_percentage")
    public Optional<Map<String, JsonNode>> getDiscountPercentage() {
        return this.discountPercentage;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price")
    public double getPrice() {
        return this.price;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="term_month")
    public Optional<Integer> getTermMonth() {
        return this.termMonth;
    }

    @JsonProperty(value="total_discount")
    public Optional<Map<String, JsonNode>> getTotalDiscount() {
        return this.totalDiscount;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CrmDealLineItem && this.equalTo((CrmDealLineItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CrmDealLineItem other) {
        return this.billingFrequency.equals(other.billingFrequency) && this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.description.equals(other.description) && this.discountPercentage.equals(other.discountPercentage) && this.id.equals(other.id) && this.name.equals(other.name) && this.price == other.price && this.quantity == other.quantity && this.termMonth.equals(other.termMonth) && this.totalDiscount.equals(other.totalDiscount) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.billingFrequency, this.createdAt, this.currency, this.description, this.discountPercentage, this.id, this.name, this.price, this.quantity, this.termMonth, this.totalDiscount, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingFrequencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BillingFrequencyStage,
    CreatedAtStage,
    CurrencyStage,
    DescriptionStage,
    IdStage,
    NameStage,
    PriceStage,
    QuantityStage,
    UpdatedAtStage,
    _FinalStage {
        private String billingFrequency;
        private OffsetDateTime createdAt;
        private String currency;
        private String description;
        private String id;
        private String name;
        private double price;
        private int quantity;
        private OffsetDateTime updatedAt;
        private Optional<Map<String, JsonNode>> totalDiscount = Optional.empty();
        private Optional<Integer> termMonth = Optional.empty();
        private Optional<Map<String, JsonNode>> discountPercentage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CrmDealLineItem other) {
            this.billingFrequency(other.getBillingFrequency());
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.description(other.getDescription());
            this.discountPercentage(other.getDiscountPercentage());
            this.id(other.getId());
            this.name(other.getName());
            this.price(other.getPrice());
            this.quantity(other.getQuantity());
            this.termMonth(other.getTermMonth());
            this.totalDiscount(other.getTotalDiscount());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="billing_frequency")
        public CreatedAtStage billingFrequency(@NotNull String billingFrequency) {
            this.billingFrequency = Objects.requireNonNull(billingFrequency, "billingFrequency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public DescriptionStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public QuantityStage price(double price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public UpdatedAtStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage totalDiscount(Map<String, JsonNode> totalDiscount) {
            this.totalDiscount = Optional.ofNullable(totalDiscount);
            return this;
        }

        @Override
        @JsonSetter(value="total_discount", nulls=Nulls.SKIP)
        public _FinalStage totalDiscount(Optional<Map<String, JsonNode>> totalDiscount) {
            this.totalDiscount = totalDiscount;
            return this;
        }

        @Override
        public _FinalStage termMonth(Integer termMonth) {
            this.termMonth = Optional.ofNullable(termMonth);
            return this;
        }

        @Override
        @JsonSetter(value="term_month", nulls=Nulls.SKIP)
        public _FinalStage termMonth(Optional<Integer> termMonth) {
            this.termMonth = termMonth;
            return this;
        }

        @Override
        public _FinalStage discountPercentage(Map<String, JsonNode> discountPercentage) {
            this.discountPercentage = Optional.ofNullable(discountPercentage);
            return this;
        }

        @Override
        @JsonSetter(value="discount_percentage", nulls=Nulls.SKIP)
        public _FinalStage discountPercentage(Optional<Map<String, JsonNode>> discountPercentage) {
            this.discountPercentage = discountPercentage;
            return this;
        }

        @Override
        public CrmDealLineItem build() {
            return new CrmDealLineItem(this.billingFrequency, this.createdAt, this.currency, this.description, this.discountPercentage, this.id, this.name, this.price, this.quantity, this.termMonth, this.totalDiscount, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CrmDealLineItem build();

        public _FinalStage discountPercentage(Optional<Map<String, JsonNode>> var1);

        public _FinalStage discountPercentage(Map<String, JsonNode> var1);

        public _FinalStage termMonth(Optional<Integer> var1);

        public _FinalStage termMonth(Integer var1);

        public _FinalStage totalDiscount(Optional<Map<String, JsonNode>> var1);

        public _FinalStage totalDiscount(Map<String, JsonNode> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface QuantityStage {
        public UpdatedAtStage quantity(int var1);
    }

    public static interface PriceStage {
        public QuantityStage price(double var1);
    }

    public static interface NameStage {
        public PriceStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IdStage description(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public DescriptionStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface BillingFrequencyStage {
        public CreatedAtStage billingFrequency(@NotNull String var1);

        public Builder from(CrmDealLineItem var1);
    }
}

