/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EntityTraitValue {
    private final String definitionId;
    private final String value;
    private final Map<String, Object> additionalProperties;

    private EntityTraitValue(String definitionId, String value, Map<String, Object> additionalProperties) {
        this.definitionId = definitionId;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="definition_id")
    public String getDefinitionId() {
        return this.definitionId;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EntityTraitValue && this.equalTo((EntityTraitValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntityTraitValue other) {
        return this.definitionId.equals(other.definitionId) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.definitionId, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DefinitionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DefinitionIdStage,
    ValueStage,
    _FinalStage {
        private String definitionId;
        private String value;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EntityTraitValue other) {
            this.definitionId(other.getDefinitionId());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="definition_id")
        public ValueStage definitionId(@NotNull String definitionId) {
            this.definitionId = Objects.requireNonNull(definitionId, "definitionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public EntityTraitValue build() {
            return new EntityTraitValue(this.definitionId, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EntityTraitValue build();
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull String var1);
    }

    public static interface DefinitionIdStage {
        public ValueStage definitionId(@NotNull String var1);

        public Builder from(EntityTraitValue var1);
    }
}

