/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanEntitlementsOrder {
    private final String planEntitlementId;
    private final Optional<Boolean> visible;
    private final Map<String, Object> additionalProperties;

    private PlanEntitlementsOrder(String planEntitlementId, Optional<Boolean> visible, Map<String, Object> additionalProperties) {
        this.planEntitlementId = planEntitlementId;
        this.visible = visible;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="plan_entitlement_id")
    public String getPlanEntitlementId() {
        return this.planEntitlementId;
    }

    @JsonProperty(value="visible")
    public Optional<Boolean> getVisible() {
        return this.visible;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanEntitlementsOrder && this.equalTo((PlanEntitlementsOrder)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanEntitlementsOrder other) {
        return this.planEntitlementId.equals(other.planEntitlementId) && this.visible.equals(other.visible);
    }

    public int hashCode() {
        return Objects.hash(this.planEntitlementId, this.visible);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanEntitlementIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlanEntitlementIdStage,
    _FinalStage {
        private String planEntitlementId;
        private Optional<Boolean> visible = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanEntitlementsOrder other) {
            this.planEntitlementId(other.getPlanEntitlementId());
            this.visible(other.getVisible());
            return this;
        }

        @Override
        @JsonSetter(value="plan_entitlement_id")
        public _FinalStage planEntitlementId(@NotNull String planEntitlementId) {
            this.planEntitlementId = Objects.requireNonNull(planEntitlementId, "planEntitlementId must not be null");
            return this;
        }

        @Override
        public _FinalStage visible(Boolean visible) {
            this.visible = Optional.ofNullable(visible);
            return this;
        }

        @Override
        @JsonSetter(value="visible", nulls=Nulls.SKIP)
        public _FinalStage visible(Optional<Boolean> visible) {
            this.visible = visible;
            return this;
        }

        @Override
        public PlanEntitlementsOrder build() {
            return new PlanEntitlementsOrder(this.planEntitlementId, this.visible, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanEntitlementsOrder build();

        public _FinalStage visible(Optional<Boolean> var1);

        public _FinalStage visible(Boolean var1);
    }

    public static interface PlanEntitlementIdStage {
        public _FinalStage planEntitlementId(@NotNull String var1);

        public Builder from(PlanEntitlementsOrder var1);
    }
}

