/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.OrderedPlansInGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanGroupResponseData {
    private final List<String> addOnIds;
    private final Optional<String> defaultPlanId;
    private final String id;
    private final List<OrderedPlansInGroup> planIds;
    private final Optional<Integer> trialDays;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private PlanGroupResponseData(List<String> addOnIds, Optional<String> defaultPlanId, String id, List<OrderedPlansInGroup> planIds, Optional<Integer> trialDays, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOnIds = addOnIds;
        this.defaultPlanId = defaultPlanId;
        this.id = id;
        this.planIds = planIds;
        this.trialDays = trialDays;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_ids")
    public List<String> getAddOnIds() {
        return this.addOnIds;
    }

    @JsonProperty(value="default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return this.defaultPlanId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plan_ids")
    public List<OrderedPlansInGroup> getPlanIds() {
        return this.planIds;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanGroupResponseData && this.equalTo((PlanGroupResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupResponseData other) {
        return this.addOnIds.equals(other.addOnIds) && this.defaultPlanId.equals(other.defaultPlanId) && this.id.equals(other.id) && this.planIds.equals(other.planIds) && this.trialDays.equals(other.trialDays) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOnIds, this.defaultPlanId, this.id, this.planIds, this.trialDays, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private List<OrderedPlansInGroup> planIds = new ArrayList<OrderedPlansInGroup>();
        private Optional<String> defaultPlanId = Optional.empty();
        private List<String> addOnIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanGroupResponseData other) {
            this.addOnIds(other.getAddOnIds());
            this.defaultPlanId(other.getDefaultPlanId());
            this.id(other.getId());
            this.planIds(other.getPlanIds());
            this.trialDays(other.getTrialDays());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @Override
        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage addAllPlanIds(List<OrderedPlansInGroup> planIds) {
            this.planIds.addAll(planIds);
            return this;
        }

        @Override
        public _FinalStage addPlanIds(OrderedPlansInGroup planIds) {
            this.planIds.add(planIds);
            return this;
        }

        @Override
        @JsonSetter(value="plan_ids", nulls=Nulls.SKIP)
        public _FinalStage planIds(List<OrderedPlansInGroup> planIds) {
            this.planIds.clear();
            this.planIds.addAll(planIds);
            return this;
        }

        @Override
        public _FinalStage defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        @Override
        public _FinalStage addAllAddOnIds(List<String> addOnIds) {
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @Override
        public _FinalStage addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_ids", nulls=Nulls.SKIP)
        public _FinalStage addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @Override
        public PlanGroupResponseData build() {
            return new PlanGroupResponseData(this.addOnIds, this.defaultPlanId, this.id, this.planIds, this.trialDays, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanGroupResponseData build();

        public _FinalStage addOnIds(List<String> var1);

        public _FinalStage addAddOnIds(String var1);

        public _FinalStage addAllAddOnIds(List<String> var1);

        public _FinalStage defaultPlanId(Optional<String> var1);

        public _FinalStage defaultPlanId(String var1);

        public _FinalStage planIds(List<OrderedPlansInGroup> var1);

        public _FinalStage addPlanIds(OrderedPlansInGroup var1);

        public _FinalStage addAllPlanIds(List<OrderedPlansInGroup> var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> var1);

        public _FinalStage trialPaymentMethodRequired(Boolean var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(PlanGroupResponseData var1);
    }
}

