/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanResponseData {
    private final Optional<String> audienceType;
    private final OffsetDateTime createdAt;
    private final String description;
    private final String icon;
    private final String id;
    private final String name;
    private final String planType;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private PlanResponseData(Optional<String> audienceType, OffsetDateTime createdAt, String description, String icon, String id, String name, String planType, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.createdAt = createdAt;
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.planType = planType;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="audience_type")
    public Optional<String> getAudienceType() {
        return this.audienceType;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plan_type")
    public String getPlanType() {
        return this.planType;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanResponseData && this.equalTo((PlanResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanResponseData other) {
        return this.audienceType.equals(other.audienceType) && this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.name.equals(other.name) && this.planType.equals(other.planType) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.audienceType, this.createdAt, this.description, this.icon, this.id, this.name, this.planType, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    DescriptionStage,
    IconStage,
    IdStage,
    NameStage,
    PlanTypeStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String description;
        private String icon;
        private String id;
        private String name;
        private String planType;
        private OffsetDateTime updatedAt;
        private Optional<String> audienceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanResponseData other) {
            this.audienceType(other.getAudienceType());
            this.createdAt(other.getCreatedAt());
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.name(other.getName());
            this.planType(other.getPlanType());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DescriptionStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @Override
        @JsonSetter(value="audience_type", nulls=Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @Override
        public PlanResponseData build() {
            return new PlanResponseData(this.audienceType, this.createdAt, this.description, this.icon, this.id, this.name, this.planType, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanResponseData build();

        public _FinalStage audienceType(Optional<String> var1);

        public _FinalStage audienceType(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface PlanTypeStage {
        public UpdatedAtStage planType(@NotNull String var1);
    }

    public static interface NameStage {
        public PlanTypeStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface IconStage {
        public IdStage icon(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IconStage description(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DescriptionStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(PlanResponseData var1);
    }
}

