/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RawEventResponseData {
    private final OffsetDateTime capturedAt;
    private final Optional<String> eventId;
    private final String remoteAddr;
    private final String remoteIp;
    private final String userAgent;
    private final Map<String, Object> additionalProperties;

    private RawEventResponseData(OffsetDateTime capturedAt, Optional<String> eventId, String remoteAddr, String remoteIp, String userAgent, Map<String, Object> additionalProperties) {
        this.capturedAt = capturedAt;
        this.eventId = eventId;
        this.remoteAddr = remoteAddr;
        this.remoteIp = remoteIp;
        this.userAgent = userAgent;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="captured_at")
    public OffsetDateTime getCapturedAt() {
        return this.capturedAt;
    }

    @JsonProperty(value="event_id")
    public Optional<String> getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="remote_addr")
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @JsonProperty(value="remote_ip")
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @JsonProperty(value="user_agent")
    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RawEventResponseData && this.equalTo((RawEventResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RawEventResponseData other) {
        return this.capturedAt.equals(other.capturedAt) && this.eventId.equals(other.eventId) && this.remoteAddr.equals(other.remoteAddr) && this.remoteIp.equals(other.remoteIp) && this.userAgent.equals(other.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.capturedAt, this.eventId, this.remoteAddr, this.remoteIp, this.userAgent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CapturedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CapturedAtStage,
    RemoteAddrStage,
    RemoteIpStage,
    UserAgentStage,
    _FinalStage {
        private OffsetDateTime capturedAt;
        private String remoteAddr;
        private String remoteIp;
        private String userAgent;
        private Optional<String> eventId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RawEventResponseData other) {
            this.capturedAt(other.getCapturedAt());
            this.eventId(other.getEventId());
            this.remoteAddr(other.getRemoteAddr());
            this.remoteIp(other.getRemoteIp());
            this.userAgent(other.getUserAgent());
            return this;
        }

        @Override
        @JsonSetter(value="captured_at")
        public RemoteAddrStage capturedAt(@NotNull OffsetDateTime capturedAt) {
            this.capturedAt = Objects.requireNonNull(capturedAt, "capturedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="remote_addr")
        public RemoteIpStage remoteAddr(@NotNull String remoteAddr) {
            this.remoteAddr = Objects.requireNonNull(remoteAddr, "remoteAddr must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="remote_ip")
        public UserAgentStage remoteIp(@NotNull String remoteIp) {
            this.remoteIp = Objects.requireNonNull(remoteIp, "remoteIp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_agent")
        public _FinalStage userAgent(@NotNull String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent must not be null");
            return this;
        }

        @Override
        public _FinalStage eventId(String eventId) {
            this.eventId = Optional.ofNullable(eventId);
            return this;
        }

        @Override
        @JsonSetter(value="event_id", nulls=Nulls.SKIP)
        public _FinalStage eventId(Optional<String> eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        public RawEventResponseData build() {
            return new RawEventResponseData(this.capturedAt, this.eventId, this.remoteAddr, this.remoteIp, this.userAgent, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RawEventResponseData build();

        public _FinalStage eventId(Optional<String> var1);

        public _FinalStage eventId(String var1);
    }

    public static interface UserAgentStage {
        public _FinalStage userAgent(@NotNull String var1);
    }

    public static interface RemoteIpStage {
        public UserAgentStage remoteIp(@NotNull String var1);
    }

    public static interface RemoteAddrStage {
        public RemoteIpStage remoteAddr(@NotNull String var1);
    }

    public static interface CapturedAtStage {
        public RemoteAddrStage capturedAt(@NotNull OffsetDateTime var1);

        public Builder from(RawEventResponseData var1);
    }
}

