/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertUserSubRequestBody {
    private final Optional<String> companyId;
    private final Optional<String> id;
    private final Map<String, String> keys;
    private final Optional<OffsetDateTime> lastSeenAt;
    private final Optional<String> name;
    private final Optional<Map<String, JsonNode>> traits;
    private final Optional<Boolean> updateOnly;
    private final Map<String, Object> additionalProperties;

    private UpsertUserSubRequestBody(Optional<String> companyId, Optional<String> id, Map<String, String> keys, Optional<OffsetDateTime> lastSeenAt, Optional<String> name, Optional<Map<String, JsonNode>> traits, Optional<Boolean> updateOnly, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.id = id;
        this.keys = keys;
        this.lastSeenAt = lastSeenAt;
        this.name = name;
        this.traits = traits;
        this.updateOnly = updateOnly;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="keys")
    public Map<String, String> getKeys() {
        return this.keys;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="traits")
    public Optional<Map<String, JsonNode>> getTraits() {
        return this.traits;
    }

    @JsonProperty(value="update_only")
    public Optional<Boolean> getUpdateOnly() {
        return this.updateOnly;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertUserSubRequestBody && this.equalTo((UpsertUserSubRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertUserSubRequestBody other) {
        return this.companyId.equals(other.companyId) && this.id.equals(other.id) && this.keys.equals(other.keys) && this.lastSeenAt.equals(other.lastSeenAt) && this.name.equals(other.name) && this.traits.equals(other.traits) && this.updateOnly.equals(other.updateOnly);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.id, this.keys, this.lastSeenAt, this.name, this.traits, this.updateOnly);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Map<String, String> keys = new LinkedHashMap<String, String>();
        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Map<String, JsonNode>> traits = Optional.empty();
        private Optional<Boolean> updateOnly = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpsertUserSubRequestBody other) {
            this.companyId(other.getCompanyId());
            this.id(other.getId());
            this.keys(other.getKeys());
            this.lastSeenAt(other.getLastSeenAt());
            this.name(other.getName());
            this.traits(other.getTraits());
            this.updateOnly(other.getUpdateOnly());
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="keys", nulls=Nulls.SKIP)
        public Builder keys(Map<String, String> keys) {
            this.keys.clear();
            this.keys.putAll(keys);
            return this;
        }

        public Builder putAllKeys(Map<String, String> keys) {
            this.keys.putAll(keys);
            return this;
        }

        public Builder keys(String key, String value) {
            this.keys.put(key, value);
            return this;
        }

        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public Builder lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public Builder lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="traits", nulls=Nulls.SKIP)
        public Builder traits(Optional<Map<String, JsonNode>> traits) {
            this.traits = traits;
            return this;
        }

        public Builder traits(Map<String, JsonNode> traits) {
            this.traits = Optional.ofNullable(traits);
            return this;
        }

        @JsonSetter(value="update_only", nulls=Nulls.SKIP)
        public Builder updateOnly(Optional<Boolean> updateOnly) {
            this.updateOnly = updateOnly;
            return this;
        }

        public Builder updateOnly(Boolean updateOnly) {
            this.updateOnly = Optional.ofNullable(updateOnly);
            return this;
        }

        public UpsertUserSubRequestBody build() {
            return new UpsertUserSubRequestBody(this.companyId, this.id, this.keys, this.lastSeenAt, this.name, this.traits, this.updateOnly, this.additionalProperties);
        }
    }
}

