/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.webhook.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.schematic.webhook.WebhookSignatureException;
import com.schematic.webhook.WebhookVerifier;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;

public class WebhookTestServer {
    private final int port;
    private final String secret;
    private final HttpServer server;
    private final ObjectMapper objectMapper;

    public WebhookTestServer(int port, String secret) throws IOException {
        this.port = port;
        this.secret = secret;
        this.objectMapper = new ObjectMapper();
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.server.createContext("/webhook", new WebhookHandler());
        this.server.setExecutor(null);
    }

    public void start() {
        this.server.start();
        System.out.println("Webhook test server started on port " + this.port);
        System.out.println("Ready to receive webhooks at http://localhost:" + this.port + "/webhook");
        if (this.secret != null && !this.secret.isEmpty()) {
            System.out.println("Using webhook secret: " + this.secret);
        } else {
            System.out.println("WARNING: No webhook secret provided. Signature verification will be skipped.");
        }
        System.out.println("Press Ctrl+C to stop");
    }

    public void stop() {
        this.server.stop(0);
        System.out.println("Server stopped");
    }

    public static void main(String[] args) {
        int port = 8080;
        String secret = System.getenv("SCHEMATIC_WEBHOOK_SECRET");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--port") && i + 1 < args.length) {
                try {
                    port = Integer.parseInt(args[i + 1]);
                    ++i;
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid port number: " + args[i + 1]);
                    System.exit(1);
                }
                continue;
            }
            if (args[i].equals("--secret") && i + 1 < args.length) {
                secret = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].equals("--help")) continue;
            WebhookTestServer.printUsage();
            System.exit(0);
        }
        try {
            WebhookTestServer server = new WebhookTestServer(port, secret);
            server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(server::stop));
        }
        catch (IOException e) {
            System.err.println("Error starting server: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Webhook Test Server for Schematic");
        System.out.println();
        System.out.println("Usage: java -cp <classpath> com.schematic.webhook.server.WebhookTestServer [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  --port PORT     Port to listen on (default: 8080)");
        System.out.println("  --secret SECRET Webhook secret (default: reads from SCHEMATIC_WEBHOOK_SECRET env var)");
        System.out.println("  --help          Print this help message");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  java -cp <classpath> com.schematic.webhook.server.WebhookTestServer --port 8080 --secret my_webhook_secret");
        System.out.println();
        System.out.println("  # Or using environment variables:");
        System.out.println("  export SCHEMATIC_WEBHOOK_SECRET=my_webhook_secret");
        System.out.println("  java -cp <classpath> com.schematic.webhook.server.WebhookTestServer");
        System.out.println();
        System.out.println("Notes:");
        System.out.println("  For testing with Schematic, you can use a tool like ngrok to expose");
        System.out.println("  your local server to the internet.");
    }

    private class WebhookHandler
    implements HttpHandler {
        private WebhookHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!exchange.getRequestMethod().equals("POST")) {
                this.sendResponse(exchange, 405, "Method not allowed");
                return;
            }
            String body = new BufferedReader(new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            System.out.println("\nHeaders:");
            exchange.getRequestHeaders().forEach((key, values) -> System.out.println("  " + key + ": " + String.join((CharSequence)", ", values)));
            if (WebhookTestServer.this.secret != null && !WebhookTestServer.this.secret.isEmpty()) {
                String signature = exchange.getRequestHeaders().getFirst("X-Schematic-Webhook-Signature");
                String timestamp = exchange.getRequestHeaders().getFirst("X-Schematic-Webhook-Timestamp");
                try {
                    WebhookVerifier.verifySignature(body, signature, timestamp, WebhookTestServer.this.secret);
                    System.out.println("\u2705 Signature verification successful!");
                }
                catch (WebhookSignatureException e) {
                    System.out.println("\u274c Signature verification failed: " + e.getMessage());
                    HashMap<String, String> error = new HashMap<String, String>();
                    error.put("error", e.getMessage());
                    this.sendResponse(exchange, 401, WebhookTestServer.this.objectMapper.writeValueAsString(error));
                    return;
                }
            } else {
                System.out.println("\u26a0\ufe0f No webhook secret provided, skipping signature verification");
            }
            try {
                Object json = WebhookTestServer.this.objectMapper.readValue(body, Object.class);
                System.out.println("\nPayload:");
                System.out.println(WebhookTestServer.this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(json));
            }
            catch (Exception e) {
                System.out.println("\nRaw body (not JSON):");
                System.out.println(body);
            }
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "success");
            this.sendResponse(exchange, 200, WebhookTestServer.this.objectMapper.writeValueAsString(response));
        }

        private void sendResponse(HttpExchange exchange, int statusCode, String body) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(statusCode, body.length());
            try (OutputStream os = exchange.getResponseBody();){
                os.write(body.getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

