/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.core;

import java.util.Optional;
import java.util.function.Function;

public final class Nullable<T> {

    private final Either<Optional<T>, Null> value;

    private Nullable() {
        this.value = Either.left(Optional.empty());
    }

    private Nullable(T value) {
        if (value == null) {
            this.value = Either.right(Null.INSTANCE);
        } else {
            this.value = Either.left(Optional.of(value));
        }
    }

    public static <T> Nullable<T> ofNull() {
        return new Nullable<>(null);
    }

    public static <T> Nullable<T> of(T value) {
        return new Nullable<>(value);
    }

    public static <T> Nullable<T> empty() {
        return new Nullable<>();
    }

    public static <T> Nullable<T> ofOptional(Optional<T> value) {
        if (value.isPresent()) {
            return of(value.get());
        } else {
            return empty();
        }
    }

    public boolean isNull() {
        return this.value.isRight();
    }

    public boolean isEmpty() {
        return this.value.isLeft() && !this.value.getLeft().isPresent();
    }

    public T get() {
        if (this.isNull()) {
            return null;
        }

        return this.value.getLeft().get();
    }

    public <U> Nullable<U> map(Function<? super T, ? extends U> mapper) {
        if (this.isNull()) {
            return Nullable.ofNull();
        }

        return Nullable.ofOptional(this.value.getLeft().map(mapper));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Nullable)) {
            return false;
        }

        if (((Nullable<?>) other).isNull() && this.isNull()) {
            return true;
        }

        return this.value.getLeft().equals(((Nullable<?>) other).value.getLeft());
    }

    private static final class Either<L, R> {
        private L left = null;
        private R right = null;

        private Either(L left, R right) {
            if (left != null && right != null) {
                throw new IllegalArgumentException("Left and right argument cannot both be non-null.");
            }

            if (left == null && right == null) {
                throw new IllegalArgumentException("Left and right argument cannot both be null.");
            }

            if (left != null) {
                this.left = left;
            }

            if (right != null) {
                this.right = right;
            }
        }

        public static <L, R> Either<L, R> left(L left) {
            return new Either<>(left, null);
        }

        public static <L, R> Either<L, R> right(R right) {
            return new Either<>(null, right);
        }

        public boolean isLeft() {
            return this.left != null;
        }

        public boolean isRight() {
            return this.right != null;
        }

        public L getLeft() {
            if (!this.isLeft()) {
                throw new IllegalArgumentException("Cannot get left from right Either.");
            }
            return this.left;
        }

        public R getRight() {
            if (!this.isRight()) {
                throw new IllegalArgumentException("Cannot get right from left Either.");
            }
            return this.right;
        }
    }

    private static final class Null {
        private static final Null INSTANCE = new Null();

        private Null() {}
    }
}
